/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.pandora.web.filter;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.turnbig.pandora.web.Servlets;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component(value="ContextFilter")
public class ContextFilter
extends OncePerRequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(ContextFilter.class);
    private static final String ATTR_CTX = "ctx";
    private static final String ATTR_ENV = "env";
    private static final String ATTR_VERSION = "v";
    private static final String ATTR_PRO = "PRO";
    private static final String ATTR_QUERY_PART = "Q_";
    private static final String ATTR_REQUEST_URL = "url_";
    private static final String ATTR_HREF = "href_";
    public static final String PAGINATION_ATTRNAME_PAGE = "page";
    public static final String PAGINATION_ATTRNAME_PAGESIZE = "pagesize";
    private String excludes = null;
    private Pattern excludePattern = null;
    String env;
    String version;
    @Resource(name="properties")
    Properties properties;
    private Map<String, String> project = new HashMap<String, String>();

    public void initFilterBean() throws ServletException {
        FilterConfig filterConfig = this.getFilterConfig();
        if (filterConfig != null && filterConfig.getInitParameter("excludes") != null) {
            this.excludes = filterConfig.getInitParameter("excludes");
        }
        if (this.excludes != null) {
            this.excludePattern = Pattern.compile(this.excludes);
        }
        this.env = this.properties.getProperty("pro.env", "prod");
        this.version = this.properties.getProperty("pro.version", String.valueOf(new Date().getTime()));
        Enumeration<Object> keys = this.properties.keys();
        while (keys.hasMoreElements()) {
            Object nextElement = keys.nextElement();
            if (!nextElement.toString().startsWith("pro.")) continue;
            this.project.put(StringUtils.removeStart((String)nextElement.toString(), (String)"pro."), this.properties.get(nextElement).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            String relatedpath = Servlets.getRelatedpath(request);
            if (this.excludePattern == null || !this.excludePattern.matcher(relatedpath).find()) {
                String context = Servlets.getBasePath(request);
                request.setAttribute(ATTR_CTX, (Object)context);
                request.setAttribute(ATTR_ENV, (Object)this.env);
                request.setAttribute(ATTR_VERSION, (Object)("dev".equals(this.env) ? String.valueOf(new Date().getTime()) : this.version));
                String queryPartString = ContextFilter.getQueryPartString(request, PAGINATION_ATTRNAME_PAGE, PAGINATION_ATTRNAME_PAGESIZE);
                request.setAttribute(ATTR_QUERY_PART, (Object)queryPartString);
                request.setAttribute(ATTR_REQUEST_URL, (Object)request.getRequestURL().toString());
                String q = StringUtils.isBlank((CharSequence)queryPartString) ? "" : "?" + queryPartString;
                request.setAttribute(ATTR_HREF, (Object)(request.getRequestURL().toString() + q));
                request.setAttribute(ATTR_PRO, this.project);
            }
        }
        catch (Exception e) {
            logger.error("Failed to setup common context", (Throwable)e);
        }
        finally {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    public static String getQueryPartString(HttpServletRequest request, String ... excludes) {
        StringBuilder queryBuilder = new StringBuilder();
        Map parameterMap = request.getParameterMap();
        ArrayList excludeList = Lists.newArrayList((Object[])excludes);
        for (Map.Entry entry : parameterMap.entrySet()) {
            String name = (String)entry.getKey();
            if (excludeList.contains(name)) continue;
            String[] values = (String[])entry.getValue();
            if (values == null || values.length == 0) {
                if (queryBuilder.length() != 0) {
                    queryBuilder.append('&');
                }
                queryBuilder.append(name);
                continue;
            }
            for (String value : values) {
                if (queryBuilder.length() != 0) {
                    queryBuilder.append('&');
                }
                queryBuilder.append(name);
                if (value == null) continue;
                queryBuilder.append('=');
                queryBuilder.append(value.toString());
            }
        }
        return queryBuilder.toString();
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }
}

