/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.pandora.web.springmvc.exception;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import net.turnbig.pandora.spring.ex.ApiException;
import net.turnbig.pandora.spring.ex.ServiceException;
import net.turnbig.pandora.web.springmvc.view.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
public class SpringMvcExceptionHandler
extends ResponseEntityExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(SpringMvcExceptionHandler.class);

    public String handleNoHandlerFoundException(Exception ex) {
        return "404";
    }

    @ExceptionHandler(value={ApiException.class})
    public final ResponseEntity<Result> apiExHandler(ApiException ex) {
        logger.info("api exception caught", (Throwable)ex);
        return new ResponseEntity((Object)Result.failed(ex), HttpStatus.OK);
    }

    @ExceptionHandler(value={ServiceException.class})
    public final ResponseEntity<Result> serviceExceptionHandler(ServiceException ex) {
        logger.info("service exception caught", (Throwable)ex);
        return new ResponseEntity((Object)Result.failed(ex), HttpStatus.OK);
    }

    protected ResponseEntity<Object> handleBindException(BindException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        HashMap<String, String> errors = SpringMvcExceptionHandler.extractErros(ex.getBindingResult());
        logger.info("binding exception caught", (Throwable)ex);
        return new ResponseEntity((Object)Result.failed(HttpStatus.UNPROCESSABLE_ENTITY.value(), "\u63d0\u4ea4\u7684\u6570\u636e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5", errors), HttpStatus.OK);
    }

    protected ResponseEntity<Object> handleMethodArgumentNotValid(MethodArgumentNotValidException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        HashMap<String, String> errors = SpringMvcExceptionHandler.extractErros(ex.getBindingResult());
        logger.info("binding exception caught", (Throwable)ex);
        return new ResponseEntity((Object)Result.failed(HttpStatus.UNPROCESSABLE_ENTITY.value(), "\u63d0\u4ea4\u7684\u6570\u636e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5", errors), HttpStatus.OK);
    }

    public static HashMap<String, String> extractErros(BindingResult br) {
        HashMap errors = Maps.newHashMap();
        List fieldErrors = br.getFieldErrors();
        for (FieldError fieldError : fieldErrors) {
            String field = fieldError.getField();
            String defaultMessage = fieldError.getDefaultMessage();
            errors.put(field, defaultMessage);
        }
        return errors;
    }
}

