/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.pandora.web.springmvc.poi;

import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.turnbig.pandora.web.Servlets;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.web.servlet.view.document.AbstractXlsxView;

public class PoiExcelView
extends AbstractXlsxView {
    private String downloadFileName;
    private ExcelSheetModel[] models;

    public PoiExcelView() {
    }

    public PoiExcelView(String downloadFileName, ExcelSheetModel ... models) {
        this.downloadFileName = downloadFileName;
        this.models = models;
    }

    protected void buildExcelDocument(Map<String, Object> model, Workbook workbook, HttpServletRequest request, HttpServletResponse response) throws Exception {
        XSSFWorkbook wb = (XSSFWorkbook)workbook;
        for (ExcelSheetModel excelSheetModel : this.models) {
            XSSFSheet sheet = wb.createSheet(StringUtils.defaultString((String)excelSheetModel.getName(), (String)"Sheet1"));
            int rowNum = 0;
            if (excelSheetModel.getHeader() != null && excelSheetModel.getHeader().size() > 0) {
                XSSFRow headerRow = sheet.createRow(rowNum++);
                for (int i = 0; i < excelSheetModel.getHeader().size(); ++i) {
                    Cell celli = headerRow.createCell(i, 1);
                    celli.setCellValue(excelSheetModel.getHeader().get(i));
                }
            }
            List<List<Object>> content = excelSheetModel.getContent();
            for (List<Object> datas : content) {
                XSSFRow row = sheet.createRow(rowNum++);
                for (int i = 0; i < datas.size(); ++i) {
                    XSSFCell cell;
                    Object data = datas.get(i);
                    if (data == null) {
                        row.createCell(i, 3);
                        continue;
                    }
                    if (data instanceof Number) {
                        cell = row.createCell(i, 0);
                        cell.setCellValue(((Number)datas.get(i)).doubleValue());
                        continue;
                    }
                    if (data instanceof Date) {
                        cell = row.createCell(i, 0);
                        XSSFCellStyle dateCellStyle = wb.createCellStyle();
                        dateCellStyle.setDataFormat(wb.createDataFormat().getFormat("yyyy-MM-dd HH:mm:ss"));
                        cell.setCellStyle((CellStyle)dateCellStyle);
                        cell.setCellValue((Date)datas.get(i));
                        continue;
                    }
                    cell = row.createCell(i, 1);
                    cell.setCellValue(data.toString());
                }
            }
        }
        Servlets.setFileDownloadHeader(request, response, this.downloadFileName);
    }

    public static class ExcelSheetModel {
        private String name;
        private List<String> header = Lists.newArrayList();
        private List<List<Object>> content = Lists.newArrayList();

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<String> getHeader() {
            return this.header;
        }

        public void setHeader(List<String> header) {
            this.header = header;
        }

        public List<List<Object>> getContent() {
            return this.content;
        }

        public void setContent(List<List<Object>> content) {
            this.content = content;
        }
    }
}

