/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.pandora.web.taglib;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Lazy;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Lazy(value=false)
@Component(value="_Dict_Cache_")
public class DictCache
implements ApplicationContextAware {
    public static final String BEAN_NAME = "_Dict_Cache_";
    private static final Logger logger = LoggerFactory.getLogger(DictCache.class);
    private static ApplicationContext applicationContext;
    private static DictCache instance;
    @Autowired
    @Value(value="${pro.dict.tablename}")
    private String tableName;
    @Autowired
    @Value(value="${pro.dict.field.key}")
    private String keyField;
    @Autowired
    @Value(value="${pro.dict.field.display}")
    private String displayField;
    @Autowired
    @Value(value="${pro.dict.field.value}")
    private String valueField;
    @Resource(name="dataSource")
    DataSource dataSource;
    private HashMap<String, LinkedHashMap<String, String>> mapper = Maps.newLinkedHashMap();

    @PostConstruct
    public synchronized void init() {
        logger.info("=== Start init Dict Cache center ===");
        String sql = "select %s as key, %s as value, %s as display from %s order by priority asc, %s asc";
        List list = new JdbcTemplate(this.dataSource).queryForList(String.format(sql, this.keyField, this.valueField, this.displayField, this.tableName, this.valueField));
        for (Map entry : list) {
            String key = entry.get("key").toString();
            String value = entry.get("value").toString();
            String display = entry.get("display").toString();
            this.addItem(key, value, display);
            logger.debug("add dict record : {}::{}-->{}", new Object[]{key, value, display});
        }
        logger.info("=== Init Dict Cache center done ===");
    }

    public void reload() {
        this.mapper.clear();
        this.init();
    }

    private void addItem(String key, String value, String display) {
        if (!this.mapper.containsKey(key)) {
            LinkedHashMap map = Maps.newLinkedHashMap();
            this.mapper.put(key, map);
        }
        this.mapper.get(key).put(value, display);
    }

    public LinkedHashMap<String, String> get(String key) {
        LinkedHashMap<String, String> map = this.mapper.get(key);
        if (map == null) {
            this.reload();
            return this.mapper.get(key);
        }
        return map;
    }

    public String getDisplay(String key, String value) {
        HashMap map = this.mapper.get(key);
        if (map == null) {
            this.reload();
            map = this.mapper.get(key);
        }
        return (String)map.get(value);
    }

    public String getValue(String key, String display) {
        HashMap map = this.mapper.get(key);
        if (map == null) {
            this.reload();
            map = this.mapper.get(key);
        }
        for (Map.Entry entry : map.entrySet()) {
            if (!((String)entry.getValue()).equals(display)) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    public HashMap<String, LinkedHashMap<String, String>> getMapper() {
        return this.mapper;
    }

    public static DictCache instance() {
        if (instance == null) {
            instance = (DictCache)applicationContext.getBean(BEAN_NAME);
        }
        return instance;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        DictCache.applicationContext = applicationContext;
    }

    static {
        instance = null;
    }
}

