/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.pandora.web.taglib;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import net.turnbig.pandora.web.taglib.DictCache;
import net.turnbig.pandora.web.taglib.SelectTag;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictTag
extends SelectTag {
    private static final Logger logger = LoggerFactory.getLogger(DictTag.class);
    private static final long serialVersionUID = 1L;
    protected String key;
    protected String start;
    protected String end;

    @Override
    protected Map<String, String> getOptions() {
        DictCache dictCache = DictCache.instance();
        HashMap values = dictCache.get(this.key);
        if (null == values || values.size() <= 0) {
            logger.warn("dict with key [{}] is not configurated", (Object)this.key);
            values = Maps.newHashMap();
        }
        Map items = Maps.filterKeys(values, (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                boolean available = true;
                if (StringUtils.isNotBlank((CharSequence)DictTag.this.start)) {
                    boolean bl = available = available && DictTag.this.start.compareTo(input) <= 0;
                }
                if (StringUtils.isNotBlank((CharSequence)DictTag.this.end)) {
                    available = available && DictTag.this.end.compareTo(input) >= 0;
                }
                return available;
            }
        });
        return items;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getStart() {
        return this.start;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public String getEnd() {
        return this.end;
    }

    public void setEnd(String end) {
        this.end = end;
    }
}

