/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.pandora.web.taglib;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import javax.sql.DataSource;
import net.turnbig.pandora.spring.SpringContextHolder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class DisplayTag
extends TagSupport {
    private static final long serialVersionUID = 2275383657293444605L;
    private static final Logger logger = LoggerFactory.getLogger(DisplayTag.class);
    private String displayField;
    private String valueField;
    private String entity;
    private String value;
    private Map<String, Object> valueType = new HashMap<String, Object>();

    public int doEndTag() throws JspException {
        try {
            StringBuilder sb = new StringBuilder("select {0} as output from {2} where {1} = ?");
            String sql = MessageFormat.format(sb.toString(), this.displayField, this.valueField, this.entity);
            DataSource datasource = (DataSource)SpringContextHolder.getBean("dataSource");
            JspWriter writor = this.pageContext.getOut();
            List<Map<String, Object>> list = this.getRecord(sql, datasource);
            if (list != null && list.size() > 0) {
                writor.write(list.get(0).get("output").toString());
            } else {
                writor.write("");
            }
        }
        catch (IOException e) {
            logger.warn("Error occur in diaply tag.", (Throwable)e);
        }
        return 6;
    }

    private List<Map<String, Object>> getRecord(String sql, DataSource datasource) {
        List list = null;
        String key = this.entity + "&" + this.valueField;
        if (!this.valueType.containsKey(key)) {
            try {
                if (StringUtils.isNumeric((CharSequence)this.value)) {
                    list = new JdbcTemplate(datasource).queryForList(sql, new Object[]{Integer.parseInt(this.value)});
                }
                this.valueType.put(key, Integer.class);
            }
            catch (Exception e) {
                list = new JdbcTemplate(datasource).queryForList(sql, new Object[]{this.value});
                this.valueType.put(key, String.class);
            }
        } else {
            Object param = this.value;
            Object type = this.valueType.get(key);
            if (type.equals(Integer.class)) {
                param = Integer.parseInt(this.value);
            }
            list = new JdbcTemplate(datasource).queryForList(sql, new Object[]{param});
        }
        return list;
    }

    public String getDisplayField() {
        return this.displayField;
    }

    public void setDisplayField(String displayField) {
        this.displayField = displayField;
    }

    public String getValueField() {
        return this.valueField;
    }

    public void setValueField(String valueField) {
        this.valueField = valueField;
    }

    public String getEntity() {
        return this.entity;
    }

    public void setEntity(String entity) {
        this.entity = entity;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

