/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.pandora.web.taglib;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.sql.DataSource;
import net.turnbig.pandora.spring.SpringContextHolder;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.tags.form.AbstractHtmlInputElementTag;
import org.springframework.web.servlet.tags.form.TagWriter;
import org.springframework.web.util.HtmlUtils;

public class SelectTag
extends AbstractHtmlInputElementTag {
    private static final String defaultBlankDisplayTxt = "-- \u8bf7\u9009\u62e9 --";
    protected static final long serialVersionUID = -85148664789201973L;
    protected String id;
    protected String name;
    protected String displayField;
    protected String valueField;
    protected String entity;
    protected String condition;
    protected String style;
    protected String value;
    protected String blank;
    protected String blankTxt;
    protected String groupby;
    protected String orderby;
    protected String multiple;
    protected Boolean _selected = false;

    protected int writeTagContent(TagWriter tagWriter) throws JspException {
        tagWriter.startTag("select");
        this.writeOptionalAttributes(tagWriter);
        if (Boolean.valueOf(this.getBlank()).booleanValue()) {
            this.renderOption(tagWriter, "", StringUtils.isEmpty((Object)this.getBlankTxt()) ? defaultBlankDisplayTxt : this.getBlankTxt());
        }
        if (StringUtils.isEmpty((Object)this.groupby)) {
            Map<String, String> options = this.getOptions();
            for (Map.Entry<String, String> option : options.entrySet()) {
                this.renderOption(tagWriter, option.getKey(), option.getValue());
            }
        } else {
            Collection<SelectEntry> grouped = this.getGroupedOptions();
            for (SelectEntry entry : grouped) {
                this.renderOptionGroup(tagWriter, entry);
                List<SelectEntry> children = entry.getChildren();
                for (SelectEntry child : children) {
                    this.renderOption(tagWriter, child.getValue(), child.getDisplay());
                }
            }
        }
        tagWriter.endTag(true);
        return 0;
    }

    private void renderOptionGroup(TagWriter tagWriter, SelectEntry entry) throws JspException {
        String labelDisplayString = HtmlUtils.htmlEscape((String)entry.getDisplay(), (String)"UTF-8");
        tagWriter.startTag("optgroup");
        tagWriter.writeAttribute("label", labelDisplayString);
        tagWriter.endTag();
    }

    protected Collection<SelectEntry> getGroupedOptions() {
        StringBuilder sb = new StringBuilder("select {0} as display, {1} as value, {2} as grouped from {3}");
        if (!StringUtils.isEmpty((Object)this.condition)) {
            sb.append(" where ").append(this.condition);
        }
        if (!StringUtils.isEmpty((Object)this.orderby)) {
            sb.append(" order by ").append(this.orderby);
        }
        String sql = MessageFormat.format(sb.toString(), this.displayField, this.valueField, this.groupby, this.entity);
        DataSource datasource = (DataSource)SpringContextHolder.getBean("dataSource");
        List list = new JdbcTemplate(datasource).query(sql, (RowMapper)new BeanPropertyRowMapper(SelectEntry.class));
        LinkedHashMap<String, SelectEntry> mapped = new LinkedHashMap<String, SelectEntry>();
        for (SelectEntry entry : list) {
            mapped.put(entry.getValue(), entry);
        }
        LinkedHashMap<String, SelectEntry> grouped = new LinkedHashMap<String, SelectEntry>();
        for (SelectEntry entry : list) {
            String key = entry.getGrouped();
            if (!mapped.containsKey(key)) continue;
            SelectEntry groupedEntry = (SelectEntry)mapped.get(key);
            groupedEntry.addChildren(entry);
            grouped.put(key, groupedEntry);
        }
        return grouped.values();
    }

    protected void writeOptionalAttributes(TagWriter tagWriter) throws JspException {
        tagWriter.writeOptionalAttributeValue("id", this.getId());
        tagWriter.writeOptionalAttributeValue("name", this.getName());
        tagWriter.writeOptionalAttributeValue("multiple", this.getMultiple());
        super.writeOptionalAttributes(tagWriter);
    }

    private void renderOption(TagWriter tagWriter, String value, String label) throws JspException {
        String valueDisplayString = HtmlUtils.htmlEscape((String)value.toString(), (String)"UTF-8");
        String labelDisplayString = HtmlUtils.htmlEscape((String)label.toString(), (String)"UTF-8");
        tagWriter.startTag("option");
        tagWriter.writeAttribute("value", valueDisplayString);
        if (this.value != null) {
            if (this.value.equalsIgnoreCase(value)) {
                tagWriter.writeAttribute("selected", "selected");
            }
        } else if (!this._selected.booleanValue()) {
            tagWriter.writeAttribute("selected", "selected");
            this._selected = true;
        }
        tagWriter.appendValue(labelDisplayString);
        tagWriter.endTag();
    }

    protected Map<String, String> getOptions() {
        StringBuilder sb = new StringBuilder("select {0} as display, {1} as value_ from {2}");
        if (!StringUtils.isEmpty((Object)this.condition)) {
            sb.append(" where ").append(this.condition);
        }
        if (!StringUtils.isEmpty((Object)this.orderby)) {
            sb.append(" order by ").append(this.orderby);
        }
        String sql = MessageFormat.format(sb.toString(), this.displayField, this.valueField, this.entity);
        DataSource datasource = (DataSource)SpringContextHolder.getBean("dataSource");
        List options = new JdbcTemplate(datasource).queryForList(sql);
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Map option : options) {
            result.put(option.get("value_").toString(), option.get("display").toString());
        }
        return result;
    }

    protected String resolveCssClass() throws JspException {
        return ObjectUtils.getDisplayString((Object)this.evaluate("cssClass", this.getCssClass()));
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayField() {
        return this.displayField;
    }

    public void setDisplayField(String displayField) {
        this.displayField = displayField;
    }

    public String getValueField() {
        return this.valueField;
    }

    public void setValueField(String valueField) {
        this.valueField = valueField;
    }

    public String getEntity() {
        return this.entity;
    }

    public void setEntity(String entity) {
        this.entity = entity;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getBlank() {
        return this.blank;
    }

    public void setBlank(String blank) {
        this.blank = blank;
    }

    public String getBlankTxt() {
        return this.blankTxt;
    }

    public void setBlankTxt(String blankTxt) {
        this.blankTxt = blankTxt;
    }

    public String getGroupby() {
        return this.groupby;
    }

    public void setGroupby(String groupby) {
        this.groupby = groupby;
    }

    public String getOrderby() {
        return this.orderby;
    }

    public void setOrderby(String orderby) {
        this.orderby = orderby;
    }

    public String getMultiple() {
        return this.multiple;
    }

    public void setMultiple(String multiple) {
        this.multiple = multiple;
    }

    public static class SelectEntry {
        private String value;
        private String display;
        private String grouped;
        private List<SelectEntry> children;

        public List<SelectEntry> getChildren() {
            return this.children;
        }

        public void addChildren(SelectEntry entry) {
            if (this.children == null) {
                this.children = Lists.newArrayList();
            }
            this.children.add(entry);
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getDisplay() {
            return this.display;
        }

        public void setDisplay(String display) {
            this.display = display;
        }

        public String getGrouped() {
            return this.grouped;
        }

        public void setGrouped(String grouped) {
            this.grouped = grouped;
        }
    }
}

