/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.qb;

import org.apache.commons.lang3.StringUtils;

public class Asserts {
    public static void check(boolean expression, String message) {
        if (!expression) {
            throw new IllegalStateException(message);
        }
    }

    public static void check(boolean expression, String message, Object ... args) {
        if (!expression) {
            throw new IllegalStateException(String.format(message, args));
        }
    }

    public static void notNull(Object object, String name) {
        if (object == null) {
            throw new IllegalStateException(name + " is null");
        }
    }

    public static void notEmpty(CharSequence s, String name) {
        if (StringUtils.isEmpty((CharSequence)s)) {
            throw new IllegalStateException(name + " is empty");
        }
    }

    public static void notBlank(CharSequence s, String name) {
        if (StringUtils.isBlank((CharSequence)s)) {
            throw new IllegalStateException(name + " is blank");
        }
    }

    public static void length(String[] split, int length, String name) {
        if (split == null || split.length != length) {
            throw new IllegalStateException(name + " is illegal");
        }
    }
}

