/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.qb;

import java.util.HashMap;
import java.util.Map;
import net.turnbig.qb.segment.SegmentFactory;
import net.turnbig.qb.segment.Settings;
import net.turnbig.qb.segment.SingleSegmentType;
import net.turnbig.qb.segment.SqlSegment;
import net.turnbig.qb.segment.ValueType;
import net.turnbig.qb.segment.impl.combined.AndSegment;
import net.turnbig.qb.segment.impl.combined.CombinedSqlSegment;
import net.turnbig.qb.segment.impl.combined.OrSegment;
import net.turnbig.qb.segment.impl.single.SingleSqlSegment;
import org.apache.commons.lang3.StringUtils;

public class QueryBuilder {
    private static final String COMBINE_AND = "and";
    private static final String COMBINE_OR = "or";
    private static String DEFAULT_PREFIX = "q_";
    private static String DEFAULT_GROUP_PREFIX = "[";
    private static String DEFAULT_GROUP_SUFFIX = "]";
    private static String DEFAULT_COMBINED = "default";
    private String groupPrefix = DEFAULT_GROUP_PREFIX;
    private String groupSuffix = DEFAULT_GROUP_SUFFIX;
    private String prefix = DEFAULT_PREFIX;
    private boolean pretty = false;
    private Settings settings = Settings.jdbc();

    public static QueryBuilder jdbc() {
        QueryBuilder qb = new QueryBuilder();
        qb.setSettings(Settings.jdbc());
        return qb;
    }

    public static QueryBuilder namedQuery() {
        QueryBuilder qb = new QueryBuilder();
        qb.setSettings(Settings.namedQuery());
        return qb;
    }

    public static QueryBuilder mybatis() {
        QueryBuilder qb = new QueryBuilder();
        qb.setSettings(new Settings("#{", "}", true));
        return qb;
    }

    public SqlSegment build(Map<String, String> queryMap) {
        Map<String, CombinedSqlSegment> filters = this.parseQueryMap(queryMap);
        AndSegment andCondition = new AndSegment(this.pretty);
        for (String key : filters.keySet()) {
            CombinedSqlSegment condition = filters.get(key);
            andCondition.addSegment(condition);
        }
        return andCondition;
    }

    private Map<String, CombinedSqlSegment> parseQueryMap(Map<String, String> queryMap) {
        HashMap<String, CombinedSqlSegment> filters = new HashMap<String, CombinedSqlSegment>();
        for (String key : queryMap.keySet()) {
            CombinedSqlSegment combinedSegment;
            if (!key.startsWith(this.prefix)) continue;
            String[] split = StringUtils.split((String)key, (String)"_");
            String fieldStr = split[1];
            SingleSegmentType conditionType = Enum.valueOf(SingleSegmentType.class, split[2].toUpperCase());
            ValueType propertyType = split.length == 4 ? Enum.valueOf(ValueType.class, split[3].toUpperCase()) : null;
            String combineStr = StringUtils.substringBetween((String)fieldStr, (String)this.groupPrefix, (String)this.groupSuffix);
            if (StringUtils.isNotEmpty((CharSequence)combineStr)) {
                fieldStr = StringUtils.substringAfter((String)fieldStr, (String)this.groupSuffix);
                String[] combine = combineStr.split(":");
                combinedSegment = (CombinedSqlSegment)filters.get(combine[1]);
                if (combinedSegment == null) {
                    if (combine[0].toLowerCase().equals(COMBINE_OR)) {
                        combinedSegment = new OrSegment();
                    } else if (combine[0].toLowerCase().equals(COMBINE_AND)) {
                        combinedSegment = new AndSegment();
                    }
                    filters.put(combine[1], combinedSegment);
                }
            } else {
                combinedSegment = (CombinedSqlSegment)filters.get(DEFAULT_COMBINED);
                if (combinedSegment == null) {
                    combinedSegment = new AndSegment(this.pretty);
                    filters.put(DEFAULT_COMBINED, combinedSegment);
                }
            }
            SingleSqlSegment segment = SegmentFactory.build(fieldStr, conditionType, propertyType, queryMap.get(key), this.settings);
            combinedSegment.addSegment(segment);
        }
        return filters;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public QueryBuilder prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String getGroupPrefix() {
        return this.groupPrefix;
    }

    public QueryBuilder setGroupPrefix(String groupPrefix) {
        this.groupPrefix = groupPrefix;
        return this;
    }

    public String getGroupSuffix() {
        return this.groupSuffix;
    }

    public QueryBuilder setGroupSuffix(String groupSuffix) {
        this.groupSuffix = groupSuffix;
        return this;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public QueryBuilder namedQueryPrefix(String namedQueryPrefix) {
        this.settings.setNamedQueryPrefix(namedQueryPrefix);
        return this;
    }

    public QueryBuilder namedQuerySuffix(String namedQuerySuffix) {
        this.settings.setNamedQuerySuffix(namedQuerySuffix);
        return this;
    }

    public QueryBuilder pretty(boolean pretty) {
        this.pretty = pretty;
        return this;
    }
}

