/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.qb.segment;

import java.lang.reflect.Constructor;
import java.util.Date;
import net.turnbig.qb.Asserts;
import net.turnbig.qb.ParseException;
import net.turnbig.qb.segment.Settings;
import net.turnbig.qb.segment.SingleSegmentType;
import net.turnbig.qb.segment.SqlSegment;
import net.turnbig.qb.segment.ValueType;
import net.turnbig.qb.segment.impl.combined.AndSegment;
import net.turnbig.qb.segment.impl.combined.CombinedSqlSegment;
import net.turnbig.qb.segment.impl.combined.OrSegment;
import net.turnbig.qb.segment.impl.single.SingleSqlSegment;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.DateConverter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentFactory {
    private static final Logger logger = LoggerFactory.getLogger(SegmentFactory.class);
    private Settings settings = Settings.jdbc();

    private static String[] getDateFormats() {
        String ls = "yyyy-MM-dd HH:mm:ss";
        String ss = "yyyy-MM-dd";
        String rfc3399 = "yyyy-MM-dd'T'HH:mm:ss";
        return new String[]{ls, ss, rfc3399};
    }

    public static SegmentFactory jdbc() {
        SegmentFactory sb = new SegmentFactory();
        sb.settings = Settings.jdbc();
        return sb;
    }

    public static SegmentFactory namedQuery() {
        SegmentFactory sb = new SegmentFactory();
        sb.settings = Settings.namedQuery();
        return sb;
    }

    public CombinedSqlSegment and(SqlSegment ... segments) {
        return new AndSegment().addSegments(segments);
    }

    public CombinedSqlSegment or(SqlSegment ... segments) {
        return new OrSegment().addSegments(segments);
    }

    public SingleSqlSegment eq(String fieldName, Object value) {
        return SegmentFactory.build(SingleSegmentType.EQ, fieldName, value, this.settings);
    }

    public SingleSqlSegment ne(String fieldName, Object value) {
        return SegmentFactory.build(SingleSegmentType.NE, fieldName, value, this.settings);
    }

    public SingleSqlSegment like(String fieldName, Object value) {
        return SegmentFactory.build(SingleSegmentType.LIKE, fieldName, value, this.settings);
    }

    public SingleSqlSegment llike(String fieldName, Object value) {
        return SegmentFactory.build(SingleSegmentType.LLIKE, fieldName, value, this.settings);
    }

    public SingleSqlSegment rlike(String fieldName, Object value) {
        return SegmentFactory.build(SingleSegmentType.RLIKE, fieldName, value, this.settings);
    }

    public SingleSqlSegment isNull(String fieldName) {
        return SegmentFactory.build(SingleSegmentType.ISNULL, fieldName, null, this.settings);
    }

    public SingleSqlSegment isNotNull(String fieldName) {
        return SegmentFactory.build(SingleSegmentType.ISNOTNULL, fieldName, null, this.settings);
    }

    public SingleSqlSegment isEmpty(String fieldName) {
        return SegmentFactory.build(SingleSegmentType.ISEMPTY, fieldName, null, this.settings);
    }

    public SingleSqlSegment isNotEmpty(String fieldName) {
        return SegmentFactory.build(SingleSegmentType.ISNOTEMPTY, fieldName, null, this.settings);
    }

    public SingleSqlSegment le(String fieldName, Object value) {
        return SegmentFactory.build(SingleSegmentType.LE, fieldName, value, this.settings);
    }

    public SingleSqlSegment ge(String fieldName, Object value) {
        return SegmentFactory.build(SingleSegmentType.GE, fieldName, value, this.settings);
    }

    public SingleSqlSegment lt(String fieldName, Object value) {
        return SegmentFactory.build(SingleSegmentType.LT, fieldName, value, this.settings);
    }

    public SingleSqlSegment gt(String fieldName, Object value) {
        return SegmentFactory.build(SingleSegmentType.GT, fieldName, value, this.settings);
    }

    public SingleSqlSegment in(String fieldName, Object value) {
        return SegmentFactory.build(SingleSegmentType.IN, fieldName, value, this.settings);
    }

    public SingleSqlSegment notin(String fieldName, Object value) {
        return SegmentFactory.build(SingleSegmentType.NIN, fieldName, value, this.settings);
    }

    public SingleSqlSegment any(String fieldName, Object value) {
        return SegmentFactory.build(SingleSegmentType.ANY, fieldName, value, this.settings);
    }

    public static SingleSqlSegment parse(String key, String value, Settings settings) {
        ValueType valueType;
        SingleSegmentType segmentType;
        String fieldName;
        try {
            String[] split = StringUtils.split((String)key, (String)"_");
            Asserts.length(split, 4, "To parsed key: " + key);
            fieldName = split[1];
            segmentType = Enum.valueOf(SingleSegmentType.class, split[2].toUpperCase());
            valueType = Enum.valueOf(ValueType.class, split[3].toUpperCase());
        }
        catch (Exception e) {
            logger.error("Can't parse " + key, (Throwable)e);
            throw new ParseException("Can't parse {0} as a known segment.", key);
        }
        return SegmentFactory.build(fieldName, segmentType, valueType, value, settings);
    }

    public static SingleSqlSegment build(String fieldName, SingleSegmentType segmentType, ValueType valueType, String value, Settings settings) {
        try {
            String paramValue = value;
            if (!ValueType.S.equals((Object)valueType)) {
                paramValue = StringUtils.isNotBlank((CharSequence)value) ? ConvertUtils.convert((String)value, valueType.getValue()) : null;
            }
            Constructor<? extends SingleSqlSegment> constructor = segmentType.getValue().getConstructor(String.class, Object.class, Settings.class);
            return constructor.newInstance(fieldName, paramValue, settings);
        }
        catch (Exception e) {
            logger.error("Can't build segment.", (Throwable)e);
            throw new ParseException("Can't build segment.");
        }
    }

    public static SingleSqlSegment build(SingleSegmentType segmentType, String fieldName, Object value, Settings settings) {
        try {
            Constructor<? extends SingleSqlSegment> constructor = segmentType.getValue().getConstructor(String.class, Object.class, Settings.class);
            return constructor.newInstance(fieldName, value, settings);
        }
        catch (Exception e) {
            logger.error("Can't build segment.", (Throwable)e);
            throw new ParseException("Can't build segment.");
        }
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    static {
        DateConverter dtConverter = new DateConverter();
        dtConverter.setPatterns(SegmentFactory.getDateFormats());
        ConvertUtils.register((Converter)dtConverter, Date.class);
    }
}

