/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.qb.segment.impl.combined;

import java.util.ArrayList;
import java.util.List;
import net.turnbig.qb.segment.SqlSegment;
import org.apache.commons.lang3.StringUtils;

public abstract class CombinedSqlSegment
extends SqlSegment {
    protected List<SqlSegment> segments = new ArrayList<SqlSegment>();
    protected boolean pretty = false;

    public CombinedSqlSegment() {
    }

    public CombinedSqlSegment(boolean pretty) {
        this.pretty = pretty;
    }

    public String join(String prefix, String suffix, String sep) {
        StringBuilder builder = new StringBuilder("(");
        ArrayList<String> list = new ArrayList<String>();
        for (SqlSegment segment : this.segments) {
            String asSql = segment.asSql();
            list.add(asSql);
        }
        String join = StringUtils.join(list, (String)((this.pretty ? " \n" : " ") + sep + " "));
        builder.append(join);
        return builder.append(")").toString();
    }

    public void addSegment(SqlSegment segment) {
        this.segments.add(segment);
        if (segment.isParamRequired()) {
            this.getParams().putAll(segment.getParams());
        }
    }

    public CombinedSqlSegment addSegments(SqlSegment ... segments) {
        for (SqlSegment segment : segments) {
            this.addSegment(segment);
        }
        return this;
    }

    public List<SqlSegment> getSegments() {
        return this.segments;
    }

    public void setSegments(List<SqlSegment> segments) {
        this.segments = segments;
    }

    @Override
    public boolean isParamRequired() {
        for (SqlSegment segment : this.segments) {
            if (!segment.isParamRequired()) continue;
            return true;
        }
        return false;
    }
}

