/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.qb.segment.impl.single;

import java.text.MessageFormat;
import net.turnbig.qb.segment.Settings;
import net.turnbig.qb.segment.SqlSegment;
import org.apache.commons.lang3.RandomStringUtils;

public abstract class SingleSqlSegment
extends SqlSegment {
    protected static final String SEGMENT = "{0} {1} {2}{3}{4}";
    protected String fieldName;
    protected String paramKey;
    protected Object paramValue;

    public SingleSqlSegment(String fieldName, Object paramValue, Settings settings) {
        this.fieldName = fieldName;
        this.paramValue = paramValue;
        this.settings = settings;
        if (this.isParamRequired()) {
            this.paramKey = this.getRandomKey();
            this.addParam(this.paramKey, this.paramValue);
        }
    }

    protected String getRandomKey() {
        return this.getFieldName().replace('.', '_') + "_" + RandomStringUtils.randomNumeric((int)3);
    }

    @Override
    public boolean isParamRequired() {
        return true;
    }

    protected String buildSql(String op) {
        Boolean useNamedQuery = this.settings.getUseNamedQuery();
        String prefix = useNamedQuery != false ? this.getSettings().getNamedQueryPrefix() : "";
        String suffix = useNamedQuery != false ? this.getSettings().getNamedQuerySuffix() : "";
        String key = useNamedQuery != false ? this.paramKey : "?";
        String sql = MessageFormat.format(this.getSqlFormatter(), this.fieldName, op, prefix, key, suffix);
        return sql;
    }

    public String getSqlFormatter() {
        return SEGMENT;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getParamKey() {
        return this.paramKey;
    }

    public void setParamKey(String paramKey) {
        this.paramKey = paramKey;
    }

    public Object getParamValue() {
        return this.paramValue;
    }

    public void setParamValue(Object paramValue) {
        this.paramValue = paramValue;
    }
}

