/*
 * Decompiled with CFR 0.152.
 */
package squery;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Squery {
    public String selection = "";
    public String[] selectionArgs = new String[0];
    public String orderBy = "";
    public int begin = 0;
    public int end = 0;
    public static final String NULL = "NULL";
    public static final String IS = "IS";
    public static final String IS_NOT = "IS NOT";
    public static final String EQUAL = "=";
    public static final String EQ = "=";
    public static final String NOT_EQUAL = "!=";
    public static final String NEQ = "!=";
    public static final String NQ = "!=";
    public static final String NE = "!=";
    public static final String LESS_EQUAL = "<=";
    public static final String LE = "<=";
    public static final String LESS_THAN = "<";
    public static final String LT = "<";
    public static final String GREATER_EQUAL = ">=";
    public static final String GE = ">=";
    public static final String GREATER_THAN = ">";
    public static final String GT = ">";
    public static final String AND = "AND";
    public static final String OR = "OR";
    public static final String NOT_IN = "NOT IN";
    public static final String IN = "IN";
    public static final String LIKE = "LIKE";
    public static final String NOT_LIKE = "NOT LIKE";
    public static final String DESC = "DESC";
    public static final String ASC = "ASC";

    public String selection() {
        if (this.begin != this.end) {
            throw new RuntimeException("No paired brace");
        }
        return this.selection;
    }

    public String[] selectionArgs() {
        if (this.begin != this.end) {
            throw new RuntimeException("No paired brace");
        }
        return this.selectionArgs;
    }

    public String orderBy() {
        if (this.begin != this.end) {
            throw new RuntimeException("No paired brace");
        }
        return this.orderBy;
    }

    public Squery() {
    }

    public Squery(Squery squery) {
        this();
        this.append(squery);
    }

    public Squery(Builder builder) {
        this();
        this.append(builder);
    }

    public Squery append(Squery squery) {
        this.selection = this.selection + squery.selection;
        ArrayList<String> s = new ArrayList<String>();
        List<String> s1 = Arrays.asList(this.selectionArgs);
        List<String> s2 = Arrays.asList(squery.selectionArgs);
        s.addAll(s1);
        s.addAll(s2);
        this.selectionArgs = s.toArray(new String[0]);
        return this;
    }

    public Squery append(Builder builder) {
        this.selection = this.selection + builder.selection;
        ArrayList<String> s = new ArrayList<String>();
        List<String> s1 = Arrays.asList(this.selectionArgs);
        List<String> s2 = Arrays.asList(builder.selectionArgs);
        s.addAll(s1);
        s.addAll(s2);
        this.selectionArgs = s.toArray(new String[0]);
        return this;
    }

    public Squery[] append(Squery[] squeries) {
        return squeries;
    }

    public Squery isNull(String field) {
        return this.append(Builder.isNull(field));
    }

    public Squery isNotNull(String field) {
        return this.append(Builder.isNotNull(field));
    }

    public Squery equal(String field, Object selectionArg) {
        return this.append(Builder.equal(field, selectionArg));
    }

    public Squery notEqual(String field, Object selectionArg) {
        return this.append(Builder.notEqual(field, selectionArg));
    }

    public Squery lessEqual(String field, Object selectionArg) {
        return this.append(Builder.lessEqual(field, selectionArg));
    }

    public Squery lessThan(String field, Object selectionArg) {
        return this.append(Builder.lessThan(field, selectionArg));
    }

    public Squery greaterEqual(String field, Object selectionArg) {
        return this.append(Builder.greaterEqual(field, selectionArg));
    }

    public Squery greaterThan(String field, Object selectionArg) {
        return this.append(Builder.greaterThan(field, selectionArg));
    }

    public Squery notIn(String field, Object selectionArg) {
        return this.append(Builder.notIn(field, selectionArg));
    }

    public Squery in(String field, Object selectionArg) {
        return this.append(Builder.in(field, selectionArg));
    }

    public Squery equal(String field, List<?> selectionArgs) {
        return this.append(Builder.equal(field, selectionArgs));
    }

    public Squery notEqual(String field, List<?> selectionArgs) {
        return this.append(Builder.notEqual(field, selectionArgs));
    }

    public Squery lessEqual(String field, List<?> selectionArgs) {
        return this.append(Builder.lessEqual(field, selectionArgs));
    }

    public Squery lessThan(String field, List<?> selectionArgs) {
        return this.append(Builder.lessThan(field, selectionArgs));
    }

    public Squery greaterEqual(String field, List<?> selectionArgs) {
        return this.append(Builder.greaterEqual(field, selectionArgs));
    }

    public Squery greaterThan(String field, List<?> selectionArgs) {
        return this.append(Builder.greaterThan(field, selectionArgs));
    }

    public Squery notIn(String field, List<?> selectionArgs) {
        return this.append(Builder.notIn(field, selectionArgs));
    }

    public Squery in(String field, List<?> selectionArgs) {
        return this.append(Builder.in(field, selectionArgs));
    }

    public Squery[] like(String field, List<?> selectionArgs) {
        return this.append(Builder.like(field, selectionArgs));
    }

    public Squery like(String field, Object selectionArg) {
        return this.append(Builder.like(field, selectionArg));
    }

    public Squery exactLike(String field, Object selectionArg) {
        return this.append(Builder.exactLike(field, selectionArg));
    }

    public Squery notLike(String field, Object selectionArg) {
        return this.append(Builder.notLike(field, selectionArg));
    }

    public Squery exactNotLike(String field, Object selectionArg) {
        return this.append(Builder.exactNotLike(field, selectionArg));
    }

    public Squery and() {
        this.selection = this.selection + " AND ";
        return this;
    }

    public Squery or() {
        this.selection = this.selection + " OR ";
        return this;
    }

    public Squery desc(String field) {
        return this.orderBy(field, DESC);
    }

    public Squery asc(String field) {
        return this.orderBy(field, ASC);
    }

    public Squery orderBy(String field, String op) {
        this.orderBy = this.orderBy == null || "".equals(this.orderBy) ? field + " " + op : this.orderBy + ", " + field + " " + op;
        return this;
    }

    public Squery limit(int count) {
        this.orderBy = this.orderBy + " LIMIT " + count;
        return this;
    }

    public Squery brace(Squery squery) {
        return Builder.brace(squery);
    }

    public Squery begin() {
        return Builder.begin(this);
    }

    public Squery end() {
        this.selection = this.selection + ")";
        ++this.end;
        return this;
    }

    public String toString() {
        return this.toSql();
    }

    public String toSql() {
        if (this.begin != this.end) {
            throw new RuntimeException("No paired brace");
        }
        String[] sels = this.selection.split("\\?");
        String ret = "";
        for (int i = 0; i < this.selectionArgs.length; ++i) {
            ret = ret + sels[i] + "'";
            ret = ret + this.selectionArgs[i] + "'";
        }
        ret = ret + sels[this.selectionArgs.length];
        if (this.orderBy != null && !"".equals(this.orderBy)) {
            ret = ret + " ORDERBY " + this.orderBy;
        }
        return ret;
    }

    public static class Builder {
        public String selection = "";
        public String[] selectionArgs = new String[0];
        public String orderBy = "";
        public int begin = 0;
        public int end = 0;

        public Builder() {
        }

        public Builder(Builder builder) {
            this();
            this.selection = builder.selection;
            this.selectionArgs = builder.selectionArgs;
            this.orderBy = builder.orderBy;
            this.begin = builder.begin;
            this.end = builder.end;
        }

        public Builder(Squery squery) {
            this();
            this.selection = squery.selection;
            this.selectionArgs = squery.selectionArgs;
            this.orderBy = squery.orderBy;
            this.begin = squery.begin;
            this.end = squery.end;
        }

        public static Squery isNull(String field) {
            return Builder.op(field, Squery.IS, Squery.NULL, false);
        }

        public static Squery isNotNull(String field) {
            return Builder.op(field, Squery.IS_NOT, Squery.NULL, false);
        }

        public static Squery equal(String field, Object selectionArg) {
            return Builder.op(field, "=", selectionArg);
        }

        public static Squery notEqual(String field, Object selectionArg) {
            return Builder.op(field, "!=", selectionArg);
        }

        public static Squery lessEqual(String field, Object selectionArg) {
            return Builder.op(field, "<=", selectionArg);
        }

        public static Squery lessThan(String field, Object selectionArg) {
            return Builder.op(field, "<", selectionArg);
        }

        public static Squery greaterEqual(String field, Object selectionArg) {
            return Builder.op(field, ">=", selectionArg);
        }

        public static Squery greaterThan(String field, Object selectionArg) {
            return Builder.op(field, ">", selectionArg);
        }

        public static Squery notIn(String field, Object selectionArg) {
            return Builder.op(field, Squery.NOT_IN, selectionArg);
        }

        public static Squery in(String field, Object selectionArg) {
            return Builder.op(field, Squery.IN, selectionArg);
        }

        public static Squery equal(String field, List<?> selectionArgs) {
            return Builder.op(field, "=", selectionArgs);
        }

        public static Squery notEqual(String field, List<?> selectionArgs) {
            return Builder.op(field, "!=", selectionArgs);
        }

        public static Squery lessEqual(String field, List<?> selectionArgs) {
            return Builder.op(field, "<=", selectionArgs);
        }

        public static Squery lessThan(String field, List<?> selectionArgs) {
            return Builder.op(field, "<", selectionArgs);
        }

        public static Squery greaterEqual(String field, List<?> selectionArgs) {
            return Builder.op(field, ">=", selectionArgs);
        }

        public static Squery greaterThan(String field, List<?> selectionArgs) {
            return Builder.op(field, ">", selectionArgs);
        }

        public static Squery notIn(String field, List<?> selectionArgs) {
            return Builder.op(field, Squery.NOT_IN, selectionArgs);
        }

        public static Squery in(String field, List<?> selectionArgs) {
            return Builder.in(field, selectionArgs, null);
        }

        public static Squery in(String field, List<?> selectionArgs, Boolean safe) {
            Squery out = safe != null ? Builder.op(field, Squery.IN, selectionArgs, (boolean)safe) : Builder.op(field, Squery.IN, selectionArgs);
            StringBuilder builder = new StringBuilder("");
            if (selectionArgs.isEmpty()) {
                builder.append(field);
            } else {
                int i = 0;
                builder.append("CASE " + field + " ");
                for (Object o : selectionArgs) {
                    builder.append("WHEN " + o.toString() + " THEN " + i + " ");
                    ++i;
                }
                builder.append("END");
            }
            out.orderBy = builder.toString();
            return out;
        }

        private static Squery op(String field, String op, Object selectionArg) {
            return Builder.op(field, op, selectionArg, true);
        }

        private static Squery op(String field, String op, Object selectionArg, boolean safe) {
            Squery out = new Squery();
            if (safe) {
                out.selection = "(" + field + " " + op + " ?)";
                out.selectionArgs = new String[1];
                out.selectionArgs[0] = String.valueOf(selectionArg);
            } else {
                out.selection = "(" + field + " " + op + " " + String.valueOf(selectionArg) + ")";
                out.selectionArgs = new String[0];
            }
            return out;
        }

        private static Squery op(String field, String op, List<?> selectionArgs) {
            return Builder.op(field, op, selectionArgs, false);
        }

        private static Squery op(String field, String op, List<?> selectionArgs, boolean safe) {
            Squery out = new Squery();
            int num = selectionArgs.size();
            StringBuilder buf = new StringBuilder(field + " " + op + " (");
            out.selectionArgs = safe ? new String[num] : new String[0];
            for (int i = 0; i < num; ++i) {
                String s = String.valueOf(selectionArgs.get(i));
                if (safe) {
                    buf.append("?");
                    out.selectionArgs[i] = s;
                } else {
                    buf.append(s);
                }
                if (i == num - 1) continue;
                buf.append(",");
            }
            buf.append(")");
            out.selection = "(" + buf.toString() + ")";
            return out;
        }

        public static Squery[] like(String field, List<?> selectionArgs) {
            ArrayList<Squery> builders = new ArrayList<Squery>();
            for (Object object : selectionArgs) {
                builders.add(Builder.like(field, object));
            }
            return builders.toArray(new Squery[0]);
        }

        public static Squery like(String field, Object selectionArg) {
            return Builder.op(field, Squery.LIKE, "%" + selectionArg + "%");
        }

        public static Squery exactLike(String field, Object selectionArg) {
            return Builder.op(field, Squery.LIKE, selectionArg);
        }

        public static Squery notLike(String field, Object selectionArg) {
            return Builder.op(field, Squery.NOT_LIKE, "%" + selectionArg + "%");
        }

        public static Squery exactNotLike(String field, Object selectionArg) {
            return Builder.op(field, Squery.NOT_LIKE, selectionArg);
        }

        public static Squery or(Squery ... builders) {
            return Builder.append(Squery.OR, builders);
        }

        public static Squery and(Squery ... builders) {
            return Builder.append(Squery.AND, builders);
        }

        private static Squery append(String op, Squery ... builders) {
            Squery builder = new Squery(builders[0]);
            for (int i = 1; i < builders.length; ++i) {
                builder = Builder.append(builder, op, builders[i]);
            }
            builder.selection = "(" + builder.selection + ")";
            return builder;
        }

        private static Squery append(Squery builder, String op, Squery anotherbuilder) {
            builder.selection = "(" + builder.selection + ") " + op + " (" + anotherbuilder.selection + ")";
            ArrayList<String> s = new ArrayList<String>();
            List<String> s1 = Arrays.asList(builder.selectionArgs);
            List<String> s2 = Arrays.asList(anotherbuilder.selectionArgs);
            s.addAll(s1);
            s.addAll(s2);
            builder.selectionArgs = s.toArray(new String[0]);
            return builder;
        }

        public static Squery brace(Squery squery) {
            squery.selection = "(" + squery.selection + ")";
            return squery;
        }

        public static Squery begin(Squery squery) {
            squery.selection = "(" + squery.selection;
            ++squery.begin;
            return squery;
        }

        public static Squery begin() {
            return Builder.begin(new Squery());
        }

        public String toString() {
            return this.toSql();
        }

        public String toSql() {
            if (this.begin != this.end) {
                throw new RuntimeException("No paired brace");
            }
            String[] sels = this.selection.split("\\?");
            String ret = "";
            for (int i = 0; i < this.selectionArgs.length; ++i) {
                ret = ret + sels[i] + "'";
                ret = ret + this.selectionArgs[i] + "'";
            }
            ret = ret + sels[this.selectionArgs.length];
            if (this.orderBy != null && !"".equals(this.orderBy)) {
                ret = ret + " ORDERBY " + this.orderBy;
            }
            return ret;
        }
    }
}

