/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.jdbcx.dialect;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import net.turnbig.jdbcx.dialect.SQLDialect;
import net.turnbig.jdbcx.dialect.exception.NotImplementDialectException;
import net.turnbig.jdbcx.dialect.impl.Db2Dialect;
import net.turnbig.jdbcx.dialect.impl.H2Dialect;
import net.turnbig.jdbcx.dialect.impl.HsqldbDialect;
import net.turnbig.jdbcx.dialect.impl.InformixDialect;
import net.turnbig.jdbcx.dialect.impl.MariaDialect;
import net.turnbig.jdbcx.dialect.impl.MysqlDialect;
import net.turnbig.jdbcx.dialect.impl.OracleDialect;
import net.turnbig.jdbcx.dialect.impl.PostgreDialect;
import net.turnbig.jdbcx.dialect.impl.SqliteDialect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Databases {
    mysql("MySQL", MysqlDialect.class),
    mariadb("MySQL", MariaDialect.class),
    sqlite("SQLite", SqliteDialect.class),
    hsqldb("HSQL Database Engine", HsqldbDialect.class),
    postgresql("PostgreSQL", PostgreDialect.class),
    h2("H2", H2Dialect.class),
    oracle("Oracle", OracleDialect.class),
    db2("DB2", Db2Dialect.class),
    informix("informix", InformixDialect.class);

    private static final Logger logger;
    Class<? extends SQLDialect> dialect;
    String dbName;
    static List<String> names;

    private Databases(String dbName, Class<? extends SQLDialect> dialect) {
        this.dbName = dbName;
        this.dialect = dialect;
    }

    public SQLDialect getDialect() {
        try {
            return this.dialect.newInstance();
        }
        catch (Exception e) {
            logger.error("failed to create dialect instance", (Throwable)e);
            return null;
        }
    }

    public static Databases of(String name) {
        try {
            Databases d = Databases.valueOf(name.toLowerCase());
            return d;
        }
        catch (IllegalArgumentException e) {
            String format = MessageFormat.format("Database[{0}] is not support, available databases : {1}", name, Databases.names());
            throw new IllegalArgumentException(format);
        }
    }

    public static Databases fromMetaData(DatabaseMetaData metaData) throws SQLException {
        Databases[] databases;
        String dbName = metaData.getDatabaseProductName();
        int databaseMajorVersion = metaData.getDatabaseMajorVersion();
        int databaseMinorVersion = metaData.getDatabaseMinorVersion();
        String format = MessageFormat.format("Database: {0} ({1} {2}.{3})", metaData.getURL(), dbName, databaseMajorVersion, databaseMinorVersion);
        logger.info(format);
        if (dbName == null) {
            throw new NotImplementDialectException("Unable to determine database. Database Product name is null.");
        }
        if (dbName.startsWith("Microsoft SQL Server")) {
            throw new IllegalArgumentException("Microsoft SQL Server is not support for now.");
        }
        if (dbName.startsWith("Oracle")) {
            return oracle;
        }
        if (dbName.contains("Mysql")) {
            return mysql;
        }
        for (Databases db : databases = Databases.values()) {
            if (!dbName.toLowerCase().startsWith(db.dbName.toLowerCase())) continue;
            return db;
        }
        throw new NotImplementDialectException("Unable to determine database. Database Product name is " + dbName);
    }

    public static Databases fromJdbcUrl(String jdbcUrl) {
        for (String database : Databases.names()) {
            if (jdbcUrl.indexOf(":" + database + ":") == -1) continue;
            return Databases.of(database);
        }
        return null;
    }

    public static List<String> names() {
        if (names.size() == 0) {
            Databases[] databases;
            for (Databases db : databases = Databases.values()) {
                names.add(db.name());
            }
        }
        return names;
    }

    public static void main(String[] args) {
        Databases.of("unknown");
    }

    static {
        logger = LoggerFactory.getLogger(Databases.class);
        names = new ArrayList<String>();
    }
}

