/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.jdbcx;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import net.turnbig.jdbcx.JdbcxBeanPropertyRowMapper;
import net.turnbig.jdbcx.dialect.Databases;
import net.turnbig.jdbcx.dialect.SQLDialect;
import net.turnbig.jdbcx.params.RichBeanPropertySqlParameterSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.ConversionService;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.EmptySqlParameterSource;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcDaoSupport;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Component;

@Component
public class JdbcxDaoSupport
extends NamedParameterJdbcDaoSupport {
    private static final Logger logger = LoggerFactory.getLogger(JdbcxDaoSupport.class);
    HashMap<Class<?>, BeanPropertyRowMapper<?>> beanPropsRowMapperMapper = new HashMap();
    ConversionService conversionService;
    SQLDialect dialect;
    @Autowired
    DataSource dataSource;

    public void setDialect(SQLDialect dialect) {
        this.dialect = dialect;
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @PostConstruct
    public void init() {
        this.setDataSource(this.dataSource);
        try {
            DatabaseMetaData metaData = this.dataSource.getConnection().getMetaData();
            this.dialect = Databases.fromMetaData(metaData).getDialect();
            logger.info("[jdbcx] bind dialect to : {}", this.dialect.getClass());
        }
        catch (SQLException e) {
            logger.error("could not get datasource connection url", (Throwable)e);
        }
    }

    protected <T> JdbcxBeanPropertyRowMapper<T> getBeanPropsRowMapper(Class<T> mapResultToClass) {
        if (!this.beanPropsRowMapperMapper.containsKey(mapResultToClass)) {
            this.beanPropsRowMapperMapper.put(mapResultToClass, new JdbcxBeanPropertyRowMapper<T>(mapResultToClass, this.conversionService));
        }
        return (JdbcxBeanPropertyRowMapper)this.beanPropsRowMapperMapper.get(mapResultToClass);
    }

    public <T> List<T> queryForListBean(String sql, Map<String, ?> paramMap, Class<T> mapResultToClass) throws DataAccessException {
        return this.getNamedParameterJdbcTemplate().query(sql, paramMap, this.getBeanPropsRowMapper(mapResultToClass));
    }

    public <T> List<T> queryForListBean(String sql, Object beanParamSource, Class<T> mapResultToClass) throws DataAccessException {
        return this.getNamedParameterJdbcTemplate().query(sql, (SqlParameterSource)new BeanPropertySqlParameterSource(beanParamSource), this.getBeanPropsRowMapper(mapResultToClass));
    }

    public <T> List<T> queryForListBean(String sql, Class<T> mapResultToClass) {
        return this.getNamedParameterJdbcTemplate().query(sql, this.getBeanPropsRowMapper(mapResultToClass));
    }

    public <T> T queryForBean(String sql, Object beanParamSource, Class<T> mapResultToClass) throws DataAccessException {
        return (T)this.getNamedParameterJdbcTemplate().queryForObject(sql, (SqlParameterSource)new BeanPropertySqlParameterSource(beanParamSource), this.getBeanPropsRowMapper(mapResultToClass));
    }

    public <T> T queryForBean(String sql, Map<String, ?> paramMap, Class<T> mapResultToClass) throws DataAccessException {
        return (T)this.getNamedParameterJdbcTemplate().queryForObject(sql, paramMap, this.getBeanPropsRowMapper(mapResultToClass));
    }

    public <T> T queryForBean(String sql, Class<T> mapResultToClass) {
        return (T)this.getNamedParameterJdbcTemplate().queryForObject(sql, (SqlParameterSource)EmptySqlParameterSource.INSTANCE, this.getBeanPropsRowMapper(mapResultToClass));
    }

    public Map<String, Object> queryForMap(String sql, Object beanParamSource) {
        return this.getNamedParameterJdbcTemplate().queryForMap(sql, (SqlParameterSource)new BeanPropertySqlParameterSource(beanParamSource));
    }

    public Map<String, Object> queryForMap(String sql, Map<String, ?> paramMap) {
        return this.getNamedParameterJdbcTemplate().queryForMap(sql, paramMap);
    }

    public Map<String, Object> queryForMap(String sql) {
        return this.getNamedParameterJdbcTemplate().queryForMap(sql, (SqlParameterSource)EmptySqlParameterSource.INSTANCE);
    }

    public List<Map<String, Object>> queryForListMap(String sql, Map<String, ?> paramMap) {
        return this.getNamedParameterJdbcTemplate().queryForList(sql, paramMap);
    }

    public List<Map<String, Object>> queryForListMap(String sql, Object beanParamSource) {
        return this.getNamedParameterJdbcTemplate().queryForList(sql, (SqlParameterSource)new BeanPropertySqlParameterSource(beanParamSource));
    }

    public List<Map<String, Object>> queryForListMap(String sql) {
        return this.getNamedParameterJdbcTemplate().queryForList(sql, (SqlParameterSource)EmptySqlParameterSource.INSTANCE);
    }

    public <T> T queryForObject(String sql, Class<T> requiredType) {
        return (T)this.getNamedParameterJdbcTemplate().queryForObject(sql, (SqlParameterSource)EmptySqlParameterSource.INSTANCE, requiredType);
    }

    public <T> T queryForObject(String sql, Object beanParamSource, Class<T> requiredType) {
        return (T)this.getNamedParameterJdbcTemplate().queryForObject(sql, (SqlParameterSource)new BeanPropertySqlParameterSource(beanParamSource), requiredType);
    }

    public <T> T queryForObject(String sql, Map<String, ?> paramMap, Class<T> requiredType) {
        return (T)this.getNamedParameterJdbcTemplate().queryForObject(sql, paramMap, requiredType);
    }

    public <T> List<T> queryForList(String sql, Object beanParamSource, Class<T> elementType) throws DataAccessException {
        return this.getNamedParameterJdbcTemplate().queryForList(sql, (SqlParameterSource)new BeanPropertySqlParameterSource(beanParamSource), elementType);
    }

    public <T> List<T> queryForList(String sql, Map<String, ?> paramMap, Class<T> elementType) throws DataAccessException {
        return this.getNamedParameterJdbcTemplate().queryForList(sql, paramMap, elementType);
    }

    public <T> List<T> queryForList(String sql, Class<T> elementType) {
        return this.getNamedParameterJdbcTemplate().queryForList(sql, (SqlParameterSource)EmptySqlParameterSource.INSTANCE, elementType);
    }

    public int update(String sql, Object beanParamSource) {
        return this.getNamedParameterJdbcTemplate().update(sql, (SqlParameterSource)new RichBeanPropertySqlParameterSource(beanParamSource));
    }

    public int update(String sql, Map<String, ?> paramMap) {
        return this.getNamedParameterJdbcTemplate().update(sql, paramMap);
    }

    public KeyHolder insert(String sql, Object beanParamSource) {
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        this.getNamedParameterJdbcTemplate().update(sql, (SqlParameterSource)new RichBeanPropertySqlParameterSource(beanParamSource), (KeyHolder)keyHolder);
        return keyHolder;
    }

    public KeyHolder insert(String sql, Object beanParamSource, String ... keyColumnNames) throws DataAccessException {
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        this.getNamedParameterJdbcTemplate().update(sql, (SqlParameterSource)new RichBeanPropertySqlParameterSource(beanParamSource), (KeyHolder)keyHolder, keyColumnNames);
        return keyHolder;
    }

    public KeyHolder insert(String sql, Map<String, ?> paramMap) {
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        this.getNamedParameterJdbcTemplate().update(sql, (SqlParameterSource)new MapSqlParameterSource(paramMap), (KeyHolder)keyHolder);
        return keyHolder;
    }

    public KeyHolder insert(String sql, Map<String, ?> paramMap, String ... keyColumnNames) throws DataAccessException {
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        this.getNamedParameterJdbcTemplate().update(sql, (SqlParameterSource)new MapSqlParameterSource(paramMap), (KeyHolder)keyHolder, keyColumnNames);
        return keyHolder;
    }

    public final int[] batchUpdate(String sql, Map<String, ?> ... batchValues) {
        SqlParameterSource[] batchArgs = new SqlParameterSource[batchValues.length];
        int i = 0;
        for (Map<String, ?> values : batchValues) {
            batchArgs[i] = new MapSqlParameterSource(values);
            ++i;
        }
        return this.getNamedParameterJdbcTemplate().batchUpdate(sql, batchArgs);
    }

    public final int[] batchUpdate(String sql, List<?> batchArgs) {
        SqlParameterSource[] params = new SqlParameterSource[batchArgs.size()];
        for (int i = 0; i < batchArgs.size(); ++i) {
            params[i] = batchArgs.get(i) instanceof Map ? new MapSqlParameterSource((Map)batchArgs.get(i)) : new RichBeanPropertySqlParameterSource(batchArgs.get(i));
        }
        return this.getNamedParameterJdbcTemplate().batchUpdate(sql, params);
    }
}

