/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.jdbcx.convertor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.turnbig.jdbcx.convertor.PGConvertable;
import net.turnbig.jdbcx.utilities.JsonMapper;
import org.postgresql.util.PGobject;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;

public class PGObjectConverter
implements ConditionalGenericConverter {
    private ConversionService conversionService;

    public PGObjectConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        HashSet<GenericConverter.ConvertiblePair> convertables = new HashSet<GenericConverter.ConvertiblePair>();
        convertables.add(new GenericConverter.ConvertiblePair(PGobject.class, Map.class));
        convertables.add(new GenericConverter.ConvertiblePair(PGobject.class, List.class));
        convertables.add(new GenericConverter.ConvertiblePair(PGobject.class, PGConvertable.class));
        return convertables;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source != null && source instanceof PGobject) {
            PGobject pgobject = (PGobject)source;
            String type = pgobject.getType();
            String value = pgobject.getValue();
            if ("jsonb".equals(type) || "json".equals(type)) {
                ResolvableType resolvableType = targetType.getResolvableType();
                if (resolvableType.getRawClass().isAssignableFrom(Map.class)) {
                    HashMap<String, Object> mapBean = JsonMapper.nonEmptyMapper().getMapBean(value, String.class, Object.class);
                    return mapBean;
                }
                if (resolvableType.getRawClass().isAssignableFrom(List.class)) {
                    List<Object> mapBean = JsonMapper.nonEmptyMapper().getListBean(value, Object.class);
                    return mapBean;
                }
                Object bean = JsonMapper.nonEmptyMapper().getBean(value, resolvableType.getRawClass());
                return bean;
            }
            throw new RuntimeException("postgres " + type + " convertor is not implemented");
        }
        return null;
    }

    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return PGObjectConverter.canConvertElements(sourceType.getElementTypeDescriptor(), targetType.getElementTypeDescriptor(), this.conversionService);
    }

    public static boolean canConvertElements(TypeDescriptor sourceElementType, TypeDescriptor targetElementType, ConversionService conversionService) {
        if (targetElementType == null) {
            return true;
        }
        if (sourceElementType == null) {
            return true;
        }
        if (conversionService.canConvert(sourceElementType, targetElementType)) {
            return true;
        }
        return sourceElementType.getType().isAssignableFrom(targetElementType.getType());
    }
}

