/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.jdbcx.utilities;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.deser.std.DateDeserializers;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.JSONPObject;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class JsonMapper {
    private static Logger logger = LoggerFactory.getLogger(JsonMapper.class);
    private final ObjectMapper mapper = new ObjectMapper();

    public JsonMapper() {
        this(null);
    }

    public JsonMapper(JsonInclude.Include include) {
        if (include != null) {
            this.mapper.setSerializationInclusion(include);
        }
        SimpleModule module = new SimpleModule();
        module.addDeserializer(Date.class, (JsonDeserializer)new Jackson2DateDeserializer());
        this.mapper.registerModule((Module)module);
        this.mapper.enable(SerializationFeature.INDENT_OUTPUT);
        this.mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    public static JsonMapper nonEmptyMapper() {
        return new JsonMapper(JsonInclude.Include.NON_EMPTY);
    }

    public static JsonMapper nonDefaultMapper() {
        return new JsonMapper(JsonInclude.Include.NON_DEFAULT);
    }

    public String toJson(Object object) {
        try {
            return this.mapper.writeValueAsString(object);
        }
        catch (IOException e) {
            logger.warn("write to json string error:" + object, (Throwable)e);
            return null;
        }
    }

    public <T> T getBean(String jsonString, Class<T> beanClazz) {
        if (StringUtils.isEmpty((Object)jsonString)) {
            return null;
        }
        try {
            return (T)this.mapper.readValue(jsonString, beanClazz);
        }
        catch (Exception e) {
            logger.warn("convert string to bean.", (Throwable)e);
            return null;
        }
    }

    public <T> List<T> getListBean(String jsonString, Class<T> beanClazz) {
        try {
            JavaType typeRef = TypeFactory.defaultInstance().constructParametricType(List.class, new Class[]{beanClazz});
            return (List)this.mapper.readValue(jsonString, typeRef);
        }
        catch (Exception e) {
            logger.warn("convert string to list bean.", (Throwable)e);
            return null;
        }
    }

    public <K, V> HashMap<K, V> getMapBean(String jsonString, Class<K> keyClazz, Class<V> valueClazz) {
        try {
            MapType typeRef = TypeFactory.defaultInstance().constructMapType(HashMap.class, keyClazz, valueClazz);
            return (HashMap)this.mapper.readValue(jsonString, (JavaType)typeRef);
        }
        catch (Exception e) {
            logger.warn("convert string to map bean.", (Throwable)e);
            return null;
        }
    }

    public <K, IK, IV> HashMap<K, Map<IK, IV>> getMapBean(String jsonString, Class<K> keyClazz, Class<IK> innerKeyClazz, Class<IV> innerValueClazz) {
        try {
            MapType innerType = TypeFactory.defaultInstance().constructMapType(HashMap.class, innerKeyClazz, innerValueClazz);
            JavaType keyType = TypeFactory.defaultInstance().constructType(keyClazz);
            MapType typeRef = TypeFactory.defaultInstance().constructMapType(HashMap.class, keyType, (JavaType)innerType);
            return (HashMap)this.mapper.readValue(jsonString, (JavaType)typeRef);
        }
        catch (IOException e) {
            logger.warn("convert string to map bean.", (Throwable)e);
            return null;
        }
    }

    public <T> T getBean(String jsonString, JavaType type) {
        try {
            return (T)this.mapper.readValue(jsonString, type);
        }
        catch (Exception e) {
            logger.warn("convert string to bean.", (Throwable)e);
            return null;
        }
    }

    public <T> T getBean(String jsonString, TypeReference<T> type) {
        try {
            return (T)this.mapper.readValue(jsonString, type);
        }
        catch (Exception e) {
            logger.warn("convert string to bean.", (Throwable)e);
            return null;
        }
    }

    public Map<?, ?> convertToMap(Object object) {
        try {
            return (Map)this.mapper.convertValue(object, Map.class);
        }
        catch (Exception e) {
            logger.warn("convert object to map.", (Throwable)e);
            return null;
        }
    }

    public void update(String jsonString, Object object) {
        try {
            this.mapper.readerForUpdating(object).readValue(jsonString);
        }
        catch (JsonProcessingException e) {
            logger.warn("update json string:" + jsonString + " to object:" + object + " error.", (Throwable)e);
        }
        catch (IOException e) {
            logger.warn("update json string:" + jsonString + " to object:" + object + " error.", (Throwable)e);
        }
    }

    public String toJsonP(String functionName, Object object) {
        return this.toJson(new JSONPObject(functionName, object));
    }

    public void enableEnumUseToString() {
        this.mapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        this.mapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public static void main(String[] args) {
        String json = "[{\"asddd\":1}";
        boolean isJson = true;
        try {
            ObjectMapper m = new ObjectMapper();
            if (json.trim().startsWith("[")) {
                JavaType typeRef = TypeFactory.defaultInstance().constructParametricType(List.class, new Class[]{Map.class});
                m.readValue(json, typeRef);
            } else {
                MapType typeRef = TypeFactory.defaultInstance().constructMapType(HashMap.class, String.class, Object.class);
                m.readValue(json, (JavaType)typeRef);
                m.readValue(json, (JavaType)typeRef);
            }
        }
        catch (Exception e) {
            isJson = false;
        }
        System.out.println(isJson);
    }

    public class Jackson2DateDeserializer
    extends DateDeserializers.DateDeserializer {
        private static final long serialVersionUID = -8949017939757220442L;

        public Date deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            try {
                return super.deserialize(jp, ctxt);
            }
            catch (Exception e) {
                Date convert = this.doConvertToDate(jp.getText(), Locale.CHINA);
                return convert;
            }
        }

        private DateFormat[] getDateFormats(Locale locale) {
            SimpleDateFormat ls = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            SimpleDateFormat ss = new SimpleDateFormat("yyyy-MM-dd");
            DateFormat dt1 = DateFormat.getDateTimeInstance(3, 1, locale);
            DateFormat dt2 = DateFormat.getDateTimeInstance(3, 2, locale);
            DateFormat dt3 = DateFormat.getDateTimeInstance(3, 3, locale);
            DateFormat d1 = DateFormat.getDateInstance(3, locale);
            DateFormat d2 = DateFormat.getDateInstance(2, locale);
            DateFormat d3 = DateFormat.getDateInstance(1, locale);
            SimpleDateFormat rfc3399 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            return new DateFormat[]{ls, ss, dt1, dt2, dt3, rfc3399, d1, d2, d3};
        }

        private Date doConvertToDate(Object value, Locale locale) {
            Date result = null;
            if (value instanceof String) {
                DateFormat[] dfs;
                for (DateFormat df1 : dfs = this.getDateFormats(locale)) {
                    try {
                        result = df1.parse(value.toString());
                        if (result == null) continue;
                        break;
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            } else if (value instanceof Object[]) {
                Object[] array = (Object[])value;
                if (array.length >= 1) {
                    Object v = array[0];
                    result = this.doConvertToDate(v, locale);
                }
            } else if (Date.class.isAssignableFrom(value.getClass())) {
                result = (Date)value;
            }
            return result;
        }
    }
}

