/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.jdbcx;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.turnbig.jdbcx.JdbcxDaoSupport;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.EmptySqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Component;

@Component
public class JdbcxPagingDaoSupport
extends JdbcxDaoSupport {
    public <T> Page<T> queryForListBean(String sql, Map<String, ?> paramMap, Class<T> mapResultToClass, Pageable pageable) {
        String countSql = this.dialect.getCountSql(sql);
        Integer count = this.queryForObject(countSql, paramMap, Integer.class);
        if ((long)count.intValue() > pageable.getOffset()) {
            String pageableSql = this.dialect.getPageableSql(sql, pageable);
            List list = this.getNamedParameterJdbcTemplate().query(pageableSql, paramMap, this.getBeanPropsRowMapper(mapResultToClass));
            return new PageImpl(list, pageable, (long)count.intValue());
        }
        return new PageImpl(Collections.emptyList(), pageable, (long)count.intValue());
    }

    public <T> Page<T> queryForListBean(String sql, Object beanParamSource, Class<T> mapResultToClass, Pageable pageable) {
        String countSql = this.dialect.getCountSql(sql);
        Integer count = this.queryForObject(countSql, beanParamSource, Integer.class);
        if ((long)count.intValue() > pageable.getOffset()) {
            String pageableSql = this.dialect.getPageableSql(sql, pageable);
            List list = this.getNamedParameterJdbcTemplate().query(pageableSql, (SqlParameterSource)new BeanPropertySqlParameterSource(beanParamSource), this.getBeanPropsRowMapper(mapResultToClass));
            return new PageImpl(list, pageable, (long)count.intValue());
        }
        return new PageImpl(Collections.emptyList(), pageable, (long)count.intValue());
    }

    public <T> Page<T> queryForListBean(String sql, Class<T> mapResultToClass, Pageable pageable) {
        String countSql = this.dialect.getCountSql(sql);
        Integer count = this.queryForObject(countSql, Integer.class);
        if ((long)count.intValue() > pageable.getOffset()) {
            String pageableSql = this.dialect.getPageableSql(sql, pageable);
            List list = this.getNamedParameterJdbcTemplate().query(pageableSql, this.getBeanPropsRowMapper(mapResultToClass));
            return new PageImpl(list, pageable, (long)count.intValue());
        }
        return new PageImpl(Collections.emptyList(), pageable, (long)count.intValue());
    }

    public Page<Map<String, Object>> queryForListMap(String sql, Map<String, ?> paramMap, Pageable pageable) {
        String countSql = this.dialect.getCountSql(sql);
        Integer count = this.queryForObject(countSql, paramMap, Integer.class);
        if ((long)count.intValue() > pageable.getOffset()) {
            String pageableSql = this.dialect.getPageableSql(sql, pageable);
            List list = this.getNamedParameterJdbcTemplate().queryForList(pageableSql, paramMap);
            return new PageImpl(list, pageable, (long)count.intValue());
        }
        return new PageImpl(Collections.emptyList(), pageable, (long)count.intValue());
    }

    public Page<Map<String, Object>> queryForListMap(String sql, Object beanParamSource, Pageable pageable) {
        String countSql = this.dialect.getCountSql(sql);
        Integer count = this.queryForObject(countSql, beanParamSource, Integer.class);
        if ((long)count.intValue() > pageable.getOffset()) {
            String pageableSql = this.dialect.getPageableSql(sql, pageable);
            List list = this.getNamedParameterJdbcTemplate().queryForList(pageableSql, (SqlParameterSource)new BeanPropertySqlParameterSource(beanParamSource));
            return new PageImpl(list, pageable, (long)count.intValue());
        }
        return new PageImpl(Collections.emptyList(), pageable, (long)count.intValue());
    }

    public Page<Map<String, Object>> queryForListMap(String sql, Pageable pageable) {
        String countSql = this.dialect.getCountSql(sql);
        Integer count = this.queryForObject(countSql, Integer.class);
        if ((long)count.intValue() > pageable.getOffset()) {
            String pageableSql = this.dialect.getPageableSql(sql, pageable);
            List list = this.getNamedParameterJdbcTemplate().queryForList(pageableSql, (SqlParameterSource)EmptySqlParameterSource.INSTANCE);
            return new PageImpl(list, pageable, (long)count.intValue());
        }
        return new PageImpl(Collections.emptyList(), pageable, (long)count.intValue());
    }

    public <T> Page<T> queryForList(String sql, Object beanParamSource, Class<T> elementType, Pageable pageable) {
        String countSql = this.dialect.getCountSql(sql);
        Integer count = this.queryForObject(countSql, beanParamSource, Integer.class);
        if ((long)count.intValue() > pageable.getOffset()) {
            String pageableSql = this.dialect.getPageableSql(sql, pageable);
            List list = this.getNamedParameterJdbcTemplate().queryForList(pageableSql, (SqlParameterSource)new BeanPropertySqlParameterSource(beanParamSource), elementType);
            return new PageImpl(list, pageable, (long)count.intValue());
        }
        return new PageImpl(Collections.emptyList(), pageable, (long)count.intValue());
    }

    public <T> Page<T> queryForList(String sql, Map<String, ?> paramMap, Class<T> elementType, Pageable pageable) {
        String countSql = this.dialect.getCountSql(sql);
        Integer count = this.queryForObject(countSql, paramMap, Integer.class);
        if ((long)count.intValue() > pageable.getOffset()) {
            String pageableSql = this.dialect.getPageableSql(sql, pageable);
            List list = this.getNamedParameterJdbcTemplate().queryForList(pageableSql, paramMap, elementType);
            return new PageImpl(list, pageable, (long)count.intValue());
        }
        return new PageImpl(Collections.emptyList(), pageable, (long)count.intValue());
    }

    public <T> Page<T> queryForList(String sql, Class<T> elementType, Pageable pageable) {
        String countSql = this.dialect.getCountSql(sql);
        Integer count = this.queryForObject(countSql, EmptySqlParameterSource.INSTANCE, Integer.class);
        if ((long)count.intValue() > pageable.getOffset()) {
            String pageableSql = this.dialect.getPageableSql(sql, pageable);
            List list = this.getNamedParameterJdbcTemplate().queryForList(pageableSql, (SqlParameterSource)EmptySqlParameterSource.INSTANCE, elementType);
            return new PageImpl(list, pageable, (long)count.intValue());
        }
        return new PageImpl(Collections.emptyList(), pageable, (long)count.intValue());
    }
}

