/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.jdbcx.dialect;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Limit;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.WithItem;
import net.turnbig.jdbcx.dialect.exception.GeneratePagingSqlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.Assert;

public class SelectSqlUtils {
    private static final Logger logger = LoggerFactory.getLogger(SelectSqlUtils.class);
    private static final List<SelectItem> COUNT_ITEM = new ArrayList<SelectItem>();
    private static final Alias TABLE_ALIAS;

    public static String getPageableSqlWithLimitOffset(String sql, Pageable pageable) {
        Select select = SelectSqlUtils.parseSelectSql(sql);
        SelectSqlUtils.getPageableSqlWithLimitOffset(select, pageable);
        return select.toString();
    }

    public static void getPageableSqlWithLimitOffset(Select select, Pageable pageable) {
        SelectSqlUtils.addSort(select, pageable.getSort());
        SelectBody sb = select.getSelectBody();
        if (sb instanceof PlainSelect) {
            Limit limit = new Limit();
            limit.setRowCount((long)pageable.getPageSize());
            limit.setOffset(pageable.getOffset());
            ((PlainSelect)sb).setLimit(limit);
        } else if (sb instanceof SetOperationList) {
            Limit limit = new Limit();
            limit.setRowCount((long)pageable.getPageSize());
            limit.setOffset(pageable.getOffset());
            ((SetOperationList)sb).setLimit(limit);
        } else if (sb instanceof WithItem) {
            logger.error("select body could not be a with-item, please report the issue to https://github.com/IamFive/spring-data-jdbcx");
            throw new GeneratePagingSqlException(select.toString(), "SQL body could not be a with-item");
        }
    }

    public static Select parseSelectSql(String sql) {
        Statement smt = null;
        try {
            smt = CCJSqlParserUtil.parse((String)sql);
            if (!(smt instanceof Select)) {
                throw new GeneratePagingSqlException(sql, "SQL should be a legal select SQL");
            }
            return (Select)smt;
        }
        catch (JSQLParserException e) {
            throw new GeneratePagingSqlException(sql, "SQL is illegal");
        }
    }

    public static String addSort(String sql, Sort sort) {
        Iterator iterator;
        if (sort != null && (iterator = sort.iterator()).hasNext()) {
            Select select = SelectSqlUtils.parseSelectSql(sql);
            SelectSqlUtils.addSort(select, sort);
            return select.toString();
        }
        return sql;
    }

    public static Select addSort(Select select, Sort sort) {
        Iterator iterator;
        if (sort != null && (iterator = sort.iterator()).hasNext()) {
            SelectBody sb = select.getSelectBody();
            if (sb instanceof PlainSelect) {
                List elements = ((PlainSelect)sb).getOrderByElements();
                elements = elements == null ? new ArrayList() : elements;
                elements.addAll(SelectSqlUtils.buildOrderByElements(iterator));
                ((PlainSelect)sb).setOrderByElements(elements);
            } else if (sb instanceof SetOperationList) {
                List elements = ((SetOperationList)sb).getOrderByElements();
                elements = elements == null ? new ArrayList() : elements;
                elements.addAll(SelectSqlUtils.buildOrderByElements(iterator));
                ((SetOperationList)sb).setOrderByElements(elements);
            } else if (sb instanceof WithItem) {
                logger.error("select body could not be a with-item, please report the issue to https://github.com/IamFive/spring-data-jdbcx");
                throw new GeneratePagingSqlException("SQL body could not be a with-item");
            }
        }
        return select;
    }

    public static String addSort(String sql, String ... orderbys) {
        ArrayList<Sort.Order> list = new ArrayList<Sort.Order>();
        for (String orderby : orderbys) {
            String[] split = orderby.split(" ");
            Assert.isTrue((split.length == 2 ? 1 : 0) != 0, (String)"order by string should like: property [asc|desc]");
            list.add(new Sort.Order(Sort.Direction.fromString((String)split[1]), split[0]));
        }
        if (list.size() > 0) {
            Sort sort = Sort.by(list);
            return SelectSqlUtils.addSort(sql, sort);
        }
        return sql;
    }

    private static List<OrderByElement> buildOrderByElements(Iterator<Sort.Order> iterator) {
        ArrayList<OrderByElement> list = new ArrayList<OrderByElement>();
        while (iterator.hasNext()) {
            Sort.Order order = iterator.next();
            OrderByElement e = new OrderByElement();
            e.setExpression((Expression)new Column(order.getProperty()));
            e.setAsc(Sort.Direction.ASC.equals((Object)order.getDirection()));
            e.setAscDescPresent(true);
            list.add(e);
        }
        return list;
    }

    public static String getCountSql(String sql) {
        Select select = SelectSqlUtils.parseSelectSql(sql);
        SelectBody sb = select.getSelectBody();
        if (sb instanceof PlainSelect) {
            PlainSelect plain = (PlainSelect)sb;
            plain.setOrderByElements(null);
            if (!SelectSqlUtils.hasAggregateFunc(plain)) {
                plain.setSelectItems(COUNT_ITEM);
                return select.toString();
            }
        } else if (sb instanceof SetOperationList) {
            SetOperationList list = (SetOperationList)sb;
            list.setOrderByElements(null);
        } else if (sb instanceof WithItem) {
            logger.error("select body could not be a with-item, please report the issue to https://github.com/IamFive/spring-data-jdbcx");
            throw new GeneratePagingSqlException("SQL body could not be a with-item");
        }
        return SelectSqlUtils.getCountSqlWithTempTable(select);
    }

    private static String getCountSqlWithTempTable(Select select) {
        PlainSelect plainSelect = new PlainSelect();
        SubSelect subSelect = new SubSelect();
        subSelect.setSelectBody(select.getSelectBody());
        subSelect.setAlias(TABLE_ALIAS);
        plainSelect.setFromItem((FromItem)subSelect);
        plainSelect.setSelectItems(COUNT_ITEM);
        select.setSelectBody((SelectBody)plainSelect);
        return select.toString();
    }

    public static boolean hasAggregateFunc(PlainSelect select) {
        if (select.getGroupByColumnReferences() != null) {
            return true;
        }
        return select.getDistinct() != null;
    }

    public static void delOrderBy(SelectBody sb) {
        if (sb instanceof PlainSelect) {
            PlainSelect plain = (PlainSelect)sb;
            plain.setOrderByElements(null);
        } else if (sb instanceof SetOperationList) {
            SetOperationList list = (SetOperationList)sb;
            list.setOrderByElements(null);
        } else if (sb instanceof WithItem) {
            logger.error("select body could not be a with-item, please report the issue to https://github.com/IamFive/spring-data-jdbcx");
            throw new GeneratePagingSqlException("SQL body could not be a with-item");
        }
    }

    static {
        COUNT_ITEM.add((SelectItem)new SelectExpressionItem((Expression)new Column("count(*)")));
        TABLE_ALIAS = new Alias("table_count");
        TABLE_ALIAS.setUseAs(false);
    }
}

