/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.jdbcx.log4jdbc;

import java.sql.SQLFeatureNotSupportedException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import net.sf.log4jdbc.Properties;
import net.sf.log4jdbc.log.slf4j.Slf4jSpyLogDelegator;
import net.sf.log4jdbc.sql.Spy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jLog4jdbcDelegator
extends Slf4jSpyLogDelegator {
    static final Logger sqlOnlyLogger = LoggerFactory.getLogger((String)"jdbc.sqlonly");
    static final String nl = System.getProperty("line.separator");

    public void exceptionOccured(Spy spy, String methodCall, Exception e, String sql, long execTime) {
        if (!(e instanceof SQLFeatureNotSupportedException || e.getMessage().contains("unsupported") || e.getMessage().contains("not supported"))) {
            super.exceptionOccured(spy, methodCall, e, sql, execTime);
        }
    }

    private boolean shouldSqlBeLogged(String sql) {
        if (sql == null) {
            return false;
        }
        if ((sql = sql.trim()).length() < 6) {
            return false;
        }
        sql = sql.substring(0, 6).toLowerCase();
        return Properties.isDumpSqlSelect() && "select".equals(sql) || Properties.isDumpSqlInsert() && "insert".equals(sql) || Properties.isDumpSqlUpdate() && "update".equals(sql) || Properties.isDumpSqlDelete() && "delete".equals(sql) || Properties.isDumpSqlCreate() && "create".equals(sql);
    }

    private static String getDebugInfo() {
        Throwable t = new Throwable();
        t.fillInStackTrace();
        StackTraceElement[] stackTrace = t.getStackTrace();
        if (stackTrace != null) {
            StringBuffer dump = new StringBuffer();
            if (Properties.isDumpFullDebugStackTrace()) {
                boolean first = true;
                for (int i = 0; i < stackTrace.length; ++i) {
                    String className = stackTrace[i].getClassName();
                    if (className.startsWith("net.sf.log4jdbc")) continue;
                    if (first) {
                        first = false;
                    } else {
                        dump.append("  ");
                    }
                    dump.append("at ");
                    dump.append(stackTrace[i]);
                    dump.append(nl);
                }
            } else {
                int j;
                dump.append(" ");
                int firstLog4jdbcCall = 0;
                int lastApplicationCall = 0;
                for (int i = 0; i < stackTrace.length; ++i) {
                    String className = stackTrace[i].getClassName();
                    if (className.startsWith("net.sf.log4jdbc")) {
                        firstLog4jdbcCall = i;
                        continue;
                    }
                    if (!Properties.isTraceFromApplication() || !Pattern.matches(Properties.getDebugStackPrefix(), className)) continue;
                    lastApplicationCall = i;
                    break;
                }
                if ((j = lastApplicationCall) == 0) {
                    j = 1 + firstLog4jdbcCall;
                }
                dump.append(stackTrace[j].getClassName()).append(".").append(stackTrace[j].getMethodName()).append("(").append(stackTrace[j].getFileName()).append(":").append(stackTrace[j].getLineNumber()).append(")");
            }
            return dump.toString();
        }
        return null;
    }

    public void sqlOccurred(Spy spy, String methodCall, String sql) {
        if (!Properties.isDumpSqlFilteringOn() || this.shouldSqlBeLogged(sql)) {
            if (sqlOnlyLogger.isDebugEnabled()) {
                sqlOnlyLogger.debug(Slf4jLog4jdbcDelegator.getDebugInfo() + nl + spy.getConnectionNumber() + ". " + this.processSql(sql));
            } else if (sqlOnlyLogger.isInfoEnabled()) {
                sqlOnlyLogger.info(this.processSql(sql));
            }
        }
    }

    protected String processSql(String sql) {
        return new BasicFormatterImpl().format(sql);
    }

    public static class BasicFormatterImpl {
        public static final String WHITESPACE = " \n\r\f\t";
        private static final Set<String> BEGIN_CLAUSES = new HashSet<String>();
        private static final Set<String> END_CLAUSES = new HashSet<String>();
        private static final Set<String> LOGICAL = new HashSet<String>();
        private static final Set<String> QUANTIFIERS = new HashSet<String>();
        private static final Set<String> DML = new HashSet<String>();
        private static final Set<String> MISC = new HashSet<String>();
        static final String indentString = "    ";
        static final String initial = "\n    ";

        public String format(String source) {
            return new FormatProcess(source).perform();
        }

        static {
            BEGIN_CLAUSES.add("left");
            BEGIN_CLAUSES.add("right");
            BEGIN_CLAUSES.add("inner");
            BEGIN_CLAUSES.add("outer");
            BEGIN_CLAUSES.add("group");
            BEGIN_CLAUSES.add("order");
            END_CLAUSES.add("where");
            END_CLAUSES.add("set");
            END_CLAUSES.add("having");
            END_CLAUSES.add("join");
            END_CLAUSES.add("from");
            END_CLAUSES.add("by");
            END_CLAUSES.add("join");
            END_CLAUSES.add("into");
            END_CLAUSES.add("union");
            LOGICAL.add("and");
            LOGICAL.add("or");
            LOGICAL.add("when");
            LOGICAL.add("else");
            LOGICAL.add("end");
            QUANTIFIERS.add("in");
            QUANTIFIERS.add("all");
            QUANTIFIERS.add("exists");
            QUANTIFIERS.add("some");
            QUANTIFIERS.add("any");
            DML.add("insert");
            DML.add("update");
            DML.add("delete");
            MISC.add("select");
            MISC.add("on");
        }

        private static class FormatProcess {
            boolean beginLine = true;
            boolean afterBeginBeforeEnd = false;
            boolean afterByOrSetOrFromOrSelect = false;
            boolean afterValues = false;
            boolean afterOn = false;
            boolean afterBetween = false;
            boolean afterInsert = false;
            int inFunction = 0;
            int parensSinceSelect = 0;
            private LinkedList<Integer> parenCounts = new LinkedList();
            private LinkedList<Boolean> afterByOrFromOrSelects = new LinkedList();
            int indent = 1;
            StringBuilder result = new StringBuilder();
            StringTokenizer tokens;
            String lastToken;
            String token;
            String lcToken;

            public FormatProcess(String sql) {
                this.tokens = new StringTokenizer(sql, "()+*/-=<>'`\"[], \n\r\f\t", true);
            }

            public String perform() {
                this.result.append(BasicFormatterImpl.initial);
                while (this.tokens.hasMoreTokens()) {
                    String t;
                    this.token = this.tokens.nextToken();
                    this.lcToken = this.token.toLowerCase();
                    if ("'".equals(this.token)) {
                        do {
                            t = this.tokens.nextToken();
                            this.token = this.token + t;
                        } while (!"'".equals(t) && this.tokens.hasMoreTokens());
                    } else if ("\"".equals(this.token)) {
                        do {
                            t = this.tokens.nextToken();
                            this.token = this.token + t;
                        } while (!"\"".equals(t));
                    }
                    if (this.afterByOrSetOrFromOrSelect && ",".equals(this.token)) {
                        this.commaAfterByOrFromOrSelect();
                    } else if (this.afterOn && ",".equals(this.token)) {
                        this.commaAfterOn();
                    } else if ("(".equals(this.token)) {
                        this.openParen();
                    } else if (")".equals(this.token)) {
                        this.closeParen();
                    } else if (BEGIN_CLAUSES.contains(this.lcToken)) {
                        this.beginNewClause();
                    } else if (END_CLAUSES.contains(this.lcToken)) {
                        this.endNewClause();
                    } else if ("select".equals(this.lcToken)) {
                        this.select();
                    } else if (DML.contains(this.lcToken)) {
                        this.updateOrInsertOrDelete();
                    } else if ("values".equals(this.lcToken)) {
                        this.values();
                    } else if ("on".equals(this.lcToken)) {
                        this.on();
                    } else if (this.afterBetween && this.lcToken.equals("and")) {
                        this.misc();
                        this.afterBetween = false;
                    } else if (LOGICAL.contains(this.lcToken)) {
                        this.logical();
                    } else if (FormatProcess.isWhitespace(this.token)) {
                        this.white();
                    } else {
                        this.misc();
                    }
                    if (FormatProcess.isWhitespace(this.token)) continue;
                    this.lastToken = this.lcToken;
                }
                return this.result.toString();
            }

            private void commaAfterOn() {
                this.out();
                --this.indent;
                this.newline();
                this.afterOn = false;
                this.afterByOrSetOrFromOrSelect = true;
            }

            private void commaAfterByOrFromOrSelect() {
                this.out();
                this.newline();
            }

            private void logical() {
                if ("end".equals(this.lcToken)) {
                    --this.indent;
                }
                this.newline();
                this.out();
                this.beginLine = false;
            }

            private void on() {
                ++this.indent;
                this.afterOn = true;
                this.newline();
                this.out();
                this.beginLine = false;
            }

            private void misc() {
                this.out();
                if ("between".equals(this.lcToken)) {
                    this.afterBetween = true;
                }
                if (this.afterInsert) {
                    this.newline();
                    this.afterInsert = false;
                } else {
                    this.beginLine = false;
                    if ("case".equals(this.lcToken)) {
                        ++this.indent;
                    }
                }
            }

            private void white() {
                if (!this.beginLine) {
                    this.result.append(" ");
                }
            }

            private void updateOrInsertOrDelete() {
                this.out();
                ++this.indent;
                this.beginLine = false;
                if ("update".equals(this.lcToken)) {
                    this.newline();
                }
                if ("insert".equals(this.lcToken)) {
                    this.afterInsert = true;
                }
            }

            private void select() {
                this.out();
                ++this.indent;
                this.newline();
                this.parenCounts.addLast(this.parensSinceSelect);
                this.afterByOrFromOrSelects.addLast(this.afterByOrSetOrFromOrSelect);
                this.parensSinceSelect = 0;
                this.afterByOrSetOrFromOrSelect = true;
            }

            private void out() {
                this.result.append(this.token);
            }

            private void endNewClause() {
                if (!this.afterBeginBeforeEnd) {
                    --this.indent;
                    if (this.afterOn) {
                        --this.indent;
                        this.afterOn = false;
                    }
                    this.newline();
                }
                this.out();
                if (!"union".equals(this.lcToken)) {
                    ++this.indent;
                }
                this.newline();
                this.afterBeginBeforeEnd = false;
                this.afterByOrSetOrFromOrSelect = "by".equals(this.lcToken) || "set".equals(this.lcToken) || "from".equals(this.lcToken);
            }

            private void beginNewClause() {
                if (!this.afterBeginBeforeEnd) {
                    if (this.afterOn) {
                        --this.indent;
                        this.afterOn = false;
                    }
                    --this.indent;
                    this.newline();
                }
                this.out();
                this.beginLine = false;
                this.afterBeginBeforeEnd = true;
            }

            private void values() {
                --this.indent;
                this.newline();
                this.out();
                ++this.indent;
                this.newline();
                this.afterValues = true;
            }

            private void closeParen() {
                --this.parensSinceSelect;
                if (this.parensSinceSelect < 0) {
                    --this.indent;
                    this.parensSinceSelect = this.parenCounts.removeLast();
                    this.afterByOrSetOrFromOrSelect = this.afterByOrFromOrSelects.removeLast();
                }
                if (this.inFunction > 0) {
                    --this.inFunction;
                    this.out();
                } else {
                    if (!this.afterByOrSetOrFromOrSelect) {
                        --this.indent;
                        this.newline();
                    }
                    this.out();
                }
                this.beginLine = false;
            }

            private void openParen() {
                if (FormatProcess.isFunctionName(this.lastToken) || this.inFunction > 0) {
                    ++this.inFunction;
                }
                this.beginLine = false;
                if (this.inFunction > 0) {
                    this.out();
                } else {
                    this.out();
                    if (!this.afterByOrSetOrFromOrSelect) {
                        ++this.indent;
                        this.newline();
                        this.beginLine = true;
                    }
                }
                ++this.parensSinceSelect;
            }

            private static boolean isFunctionName(String tok) {
                char begin = tok.charAt(0);
                boolean isIdentifier = Character.isJavaIdentifierStart(begin) || '\"' == begin;
                return isIdentifier && !LOGICAL.contains(tok) && !END_CLAUSES.contains(tok) && !QUANTIFIERS.contains(tok) && !DML.contains(tok) && !MISC.contains(tok);
            }

            private static boolean isWhitespace(String token) {
                return BasicFormatterImpl.WHITESPACE.indexOf(token) >= 0;
            }

            private void newline() {
                this.result.append("\n");
                for (int i = 0; i < this.indent; ++i) {
                    this.result.append(BasicFormatterImpl.indentString);
                }
                this.beginLine = true;
            }
        }
    }
}

