/*
 * Decompiled with CFR 0.152.
 */
package net.turnbig.jdbcx.pageable;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;

public class PaginationHelper {
    private static final int DEFAULT_PAGE_SIZE = 10;
    public static final String PAGINATION_ATTRNAME_PAGE = "page";
    public static final String PAGINATION_ATTRNAME_PAGESIZE = "pagesize";
    public static final String PAGINATION_ATTRNAME_SORT = "sortby";
    @Autowired
    private HttpServletRequest context;

    private Sort buildSortBy(String sortby) {
        Sort sort = null;
        if (StringUtils.isNotBlank((CharSequence)sortby)) {
            String[] split;
            for (String s : split = StringUtils.split((String)sortby, (String)",")) {
                String field;
                boolean isDesc = StringUtils.startsWith((CharSequence)s, (CharSequence)"-");
                String string = field = isDesc ? StringUtils.removeStart((String)s, (String)"-") : s;
                sort = sort == null ? Sort.by((Sort.Direction)(isDesc ? Sort.Direction.DESC : Sort.Direction.ASC), (String[])new String[]{field}) : sort.and(Sort.by((Sort.Direction)(isDesc ? Sort.Direction.DESC : Sort.Direction.ASC), (String[])new String[]{field}));
            }
        }
        return sort;
    }

    public PageRequest getPagination(String sortby) {
        return this.getPagination(10, sortby);
    }

    public PageRequest getPagination(Integer pageSize, String sortby) {
        String _sortby = this.context.getParameter(PAGINATION_ATTRNAME_SORT);
        if (StringUtils.isNotBlank((CharSequence)_sortby)) {
            sortby = _sortby;
        }
        String page = StringUtils.defaultString((String)this.context.getParameter(PAGINATION_ATTRNAME_PAGE), (String)"1");
        String size = StringUtils.defaultString((String)this.context.getParameter(PAGINATION_ATTRNAME_PAGESIZE), (String)String.valueOf(pageSize));
        PageRequest pageRequest = null;
        Sort sort = this.buildSortBy(sortby);
        pageRequest = sort != null ? PageRequest.of((int)(Integer.parseInt(page) - 1), (int)Integer.parseInt(size), (Sort)sort) : PageRequest.of((int)(Integer.parseInt(page) - 1), (int)Integer.parseInt(size));
        return pageRequest;
    }

    public PageRequest getPagination() {
        return this.getPagination(null);
    }

    public static Map<String, Object> toMap(Page<?> page) {
        HashMap map = Maps.newHashMap();
        map.put("content", page.getContent());
        map.put("totalPages", page.getTotalPages());
        map.put("totalElements", page.getTotalElements());
        map.put("last", page.isLast());
        map.put("first", page.isFirst());
        map.put("pageSize", page.getSize());
        map.put(PAGINATION_ATTRNAME_PAGE, page.getNumber() + 1);
        map.put("numberOfElements", page.getNumberOfElements());
        return map;
    }
}

