/*
 * Decompiled with CFR 0.152.
 */
package net.vonbuchholtz.sbt.dependencycheck;

import java.io.File;
import java.io.IOException;
import org.owasp.dependencycheck.utils.Settings;
import sbt.Logger;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;

public final class DependencyCheckPurgeTask$ {
    public static final DependencyCheckPurgeTask$ MODULE$;

    static {
        new DependencyCheckPurgeTask$();
    }

    public void purge(Option<String> connectionString, Settings settings, Logger log) {
        if (connectionString.isDefined()) {
            throw new IllegalStateException("Unable to purge the local NVD when using a non-default connection string");
        }
        try {
            File db = new File(settings.getDataDirectory(), "dc.h2.db");
            if (db.exists()) {
                if (db.delete()) {
                    log.info((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Database file purged; local copy of the NVD has been removed";
                        }
                    });
                } else {
                    log.error((Function0)new Serializable(db){
                        public static final long serialVersionUID = 0L;
                        private final File db$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to delete '", "'; please delete the file manually"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.db$1.getAbsolutePath()}));
                        }
                        {
                            this.db$1 = db$1;
                        }
                    });
                }
            } else {
                log.error((Function0)new Serializable(db){
                    public static final long serialVersionUID = 0L;
                    private final File db$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to delete '", "'; the database file does not exists"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.db$1.getAbsolutePath()}));
                    }
                    {
                        this.db$1 = db$1;
                    }
                });
            }
            return;
        }
        catch (IOException iOException) {
            log.error((Function0)new Serializable(iOException){
                public static final long serialVersionUID = 0L;
                private final IOException e$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't purge NVD database: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.e$1.getLocalizedMessage()}));
                }
                {
                    this.e$1 = e$1;
                }
            });
            throw iOException;
        }
        finally {
            settings.cleanup();
        }
    }

    private DependencyCheckPurgeTask$() {
        MODULE$ = this;
    }
}

