/*
 * Decompiled with CFR 0.152.
 */
package net.vonbuchholtz.sbt.dependencycheck;

import java.io.File;
import java.io.IOException;
import org.owasp.dependencycheck.utils.Settings;
import sbt.util.Logger;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;

public final class DependencyCheckPurgeTask$ {
    public static DependencyCheckPurgeTask$ MODULE$;

    static {
        new DependencyCheckPurgeTask$();
    }

    public void purge(Option<String> connectionString, Settings settings, Logger log) {
        if (connectionString.isDefined()) {
            throw new IllegalStateException("Unable to purge the local NVD when using a non-default connection string");
        }
        Settings.setInstance((Settings)settings);
        try {
            try {
                File db = new File(Settings.getDataDirectory(), "dc.h2.db");
                if (db.exists()) {
                    if (db.delete()) {
                        log.info((Function0 & java.io.Serializable & Serializable)() -> "Database file purged; local copy of the NVD has been removed");
                    } else {
                        log.error((Function0 & java.io.Serializable & Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to delete '", "'; please delete the file manually"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{db.getAbsolutePath()})));
                    }
                } else {
                    log.error((Function0 & java.io.Serializable & Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to delete '", "'; the database file does not exists"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{db.getAbsolutePath()})));
                }
            }
            catch (IOException e) {
                log.error((Function0 & java.io.Serializable & Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't purge NVD database: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.getLocalizedMessage()})));
                throw e;
            }
        }
        finally {
            Settings.cleanup();
        }
    }

    private DependencyCheckPurgeTask$() {
        MODULE$ = this;
    }
}

