/*
 * Decompiled with CFR 0.152.
 */
package net.vonbuchholtz.sbt.dependencycheck;

import java.io.File;
import java.io.IOException;
import org.owasp.dependencycheck.utils.Settings;
import sbt.util.Logger;
import scala.Function0;
import scala.Option;
import scala.Serializable;

public final class DependencyCheckPurgeTask$ {
    public static DependencyCheckPurgeTask$ MODULE$;

    static {
        new DependencyCheckPurgeTask$();
    }

    public void purge(Option<String> connectionString, Settings settings, Logger log) {
        if (connectionString.isDefined()) {
            throw new IllegalStateException("Unable to purge the local NVD when using a non-default connection string");
        }
        try {
            try {
                File db = new File(settings.getDataDirectory(), "dc.h2.db");
                if (db.exists()) {
                    if (db.delete()) {
                        log.info((Function0 & java.io.Serializable & Serializable)() -> "Database file purged; local copy of the NVD has been removed");
                    } else {
                        log.error((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(52).append("Unable to delete '").append(db.getAbsolutePath()).append("'; please delete the file manually").toString());
                    }
                } else {
                    log.error((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(54).append("Unable to delete '").append(db.getAbsolutePath()).append("'; the database file does not exists").toString());
                }
            }
            catch (IOException e) {
                log.error((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(26).append("Can't purge NVD database: ").append(e.getLocalizedMessage()).toString());
                throw e;
            }
        }
        finally {
            settings.cleanup();
        }
    }

    private DependencyCheckPurgeTask$() {
        MODULE$ = this;
    }
}

