/*
 * Decompiled with CFR 0.152.
 */
package net.vsame.url2sql.utils;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import net.vsame.url2sql.helper.Url2SqlContext;
import net.vsame.url2sql.helper.WebHelper;
import net.vsame.url2sql.sql.Model;
import net.vsame.url2sql.utils.JarUtils;
import net.vsame.url2sql.utils.PageView;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JdbcUtils {
    private static Log LOG = LogFactory.getLog(JdbcUtils.class);
    private static String className = "com.mysql.jdbc.Driver";
    private static String url = null;
    private static String username = null;
    private static String password = null;

    private static void loadJDBC() throws Exception {
        Properties retVal = JarUtils.loadProperties(JarUtils.getResourceAsStreamFromClassPath("jdbc.properties"));
        if (retVal == null) {
            return;
        }
        className = retVal.getProperty("className");
        url = retVal.getProperty("url");
        username = retVal.getProperty("username");
        password = retVal.getProperty("password");
        Class.forName(className);
    }

    public static Connection getConnection(String url, String username, String password) {
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(url, username, password);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage());
        }
        return conn;
    }

    public static Connection getConnection() {
        return JdbcUtils.getConnection(url, username, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void free(ResultSet rs, Statement stmt, Connection conn) {
        try {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (conn != null) {
                        conn.close();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void free(ResultSet rs, Statement stmt) {
        JdbcUtils.free(rs, stmt, null);
    }

    private void setPstmtValues(PreparedStatement pstmt, Object ... values) throws SQLException {
        if (pstmt != null & values != null) {
            for (int i = 0; i < values.length; ++i) {
                pstmt.setObject(i + 1, values[i]);
            }
        }
    }

    public int execute(CallBack callBack, String sql, Object ... values) {
        LOG.debug((Object)(sql + "|" + Arrays.toString(values)));
        Connection conn = WebHelper.getContext().getConn();
        int retVal = 0;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = callBack != null ? conn.prepareStatement(sql, 1) : conn.prepareStatement(sql);
            this.setPstmtValues(pstmt, values);
            retVal = pstmt.executeUpdate();
            if (callBack != null) {
                rs = pstmt.getGeneratedKeys();
                callBack.callback(rs);
            }
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.free(rs, pstmt);
                throw throwable;
            }
        }
        JdbcUtils.free(rs, pstmt);
        return retVal;
    }

    public int execute(String sql, Object ... values) {
        return this.execute(null, sql, values);
    }

    public int[] executeBeatch(String sql, List<List<?>> paramList) {
        LOG.debug((Object)(sql + "|" + paramList));
        int[] retVal = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = WebHelper.getContext().getConn().prepareStatement(sql);
            for (List<?> list : paramList) {
                this.setPstmtValues(pstmt, list.toArray());
                pstmt.addBatch();
            }
            retVal = pstmt.executeBatch();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            JdbcUtils.free(rs, pstmt);
        }
        return retVal;
    }

    public void query(CallBack callBack, String sql, Object ... values) {
        LOG.debug((Object)(sql + "|" + Arrays.toString(values)));
        Connection conn = WebHelper.getContext().getConn();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = conn.prepareStatement(sql);
            this.setPstmtValues(pstmt, values);
            rs = pstmt.executeQuery();
            callBack.callback(rs);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.free(rs, pstmt);
                throw throwable;
            }
        }
        JdbcUtils.free(rs, pstmt);
    }

    public List<String> getAllTables() {
        Connection conn = WebHelper.getContext().getConn();
        String[] types = new String[]{"TABLE"};
        ArrayList<String> tables = new ArrayList<String>();
        ResultSet rs = null;
        try {
            DatabaseMetaData data = conn.getMetaData();
            rs = data.getTables(null, null, null, types);
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                tables.add(tableName);
            }
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.free(rs, null);
                throw throwable;
            }
        }
        JdbcUtils.free(rs, null);
        return tables;
    }

    public Long executeGeneratedKey(String sql, Object ... values) {
        final Long[] longs = new Long[1];
        this.execute(new CallBack(){

            @Override
            public void callback(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    try {
                        longs[0] = rs.getLong(1);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }, sql, values);
        return longs[0];
    }

    public List<Model> queryList(String sql, Object ... values) {
        final ArrayList<Model> list = new ArrayList<Model>();
        this.query(new CallBack(){

            @Override
            public void callback(ResultSet rs) throws SQLException {
                ResultSetMetaData data = rs.getMetaData();
                ArrayList<String> dataColumns = new ArrayList<String>();
                for (int i = 0; i < data.getColumnCount(); ++i) {
                    dataColumns.add(data.getColumnLabel(i + 1));
                }
                while (rs.next()) {
                    Model m = new Model();
                    try {
                        for (String key : dataColumns) {
                            m.put(key, rs.getObject(key));
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    list.add(m);
                }
            }
        }, sql, values);
        return list;
    }

    public Model queryOne(String sql, Object ... values) {
        List<Model> list = this.queryList(sql, values);
        if (list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public long queryCount(String sql, Object ... values) {
        final ArrayList list = new ArrayList();
        this.query(new CallBack(){

            @Override
            public void callback(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    list.add(rs.getLong(1));
                }
            }
        }, sql, values);
        return (Long)list.get(0);
    }

    public PageView page(int currentpage, int pagesize, String sql, Object ... values) {
        PageView v = new PageView(pagesize, currentpage);
        long count = this.queryCount("select count(*) count from (" + sql + ") b", values);
        v.setTotal(count);
        if ((long)v.calcFirstResult() < count) {
            String temp = sql + " limit " + v.calcFirstResult() + "," + v.getPagesize();
            List<Model> datas = this.queryList(temp, values);
            v.setDatas(datas);
        } else {
            v.setDatas(new ArrayList<Model>());
        }
        return v;
    }

    public static void main(String[] args) throws Exception {
        WebHelper.init(null, null);
        Url2SqlContext c = WebHelper.getContext();
        c.getConn().setAutoCommit(true);
        JdbcUtils jdbcUtils = new JdbcUtils();
        PageView page = jdbcUtils.page(1, 2, "select id from `student` where 1=1", new Object[0]);
        System.out.println(page);
    }

    static {
        try {
            JdbcUtils.loadJDBC();
        }
        catch (Exception e) {
            LOG.error((Object)("JDBC\u9a71\u52a8\u52a0\u8f7d\u5931\u8d25\uff1a" + e.getMessage()), (Throwable)e);
        }
    }

    public static interface CallBack {
        public void callback(ResultSet var1) throws SQLException;
    }
}

