/*
 * Decompiled with CFR 0.152.
 */
package net.vsame.url2sql.helper;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.vsame.url2sql.helper.SqlHelper;
import net.vsame.url2sql.helper.Url2SqlContext;
import net.vsame.url2sql.helper.WebHelper;
import net.vsame.url2sql.sql.Model;
import net.vsame.url2sql.utils.JdbcUtils;
import net.vsame.url2sql.utils.PageView;

public class SqlHelperInstance {
    private static final Pattern pattern = Pattern.compile("\\$\\{(.*?)\\}|\\?");
    private static Map<String, CustomTag> customTagMap = new HashMap<String, CustomTag>();
    private JdbcUtils jdbcUtils = new JdbcUtils();

    public SqlHelperInstance() {
        this.jdbcUtils = new JdbcUtils();
    }

    public SqlHelperInstance(JdbcUtils jdbcUtils) {
        this.jdbcUtils = jdbcUtils;
    }

    public static void registCustomTag(CustomTag customTag) {
        customTagMap.put(customTag.getTagName().toLowerCase(), customTag);
    }

    private static Object calcCustomTagValue(String key) {
        String[] arrays = key.split(":");
        CustomTag ct = customTagMap.get(arrays[0].toLowerCase());
        if (ct == null) {
            throw new RuntimeException("No CustomTag name ~" + key + "!!!");
        }
        String[] params = Arrays.copyOfRange(arrays, 1, arrays.length);
        return ct.invoke(params);
    }

    public static Object[] toObjectArray(Object obj) {
        if (obj == null || !obj.getClass().isArray()) {
            return new Object[]{obj};
        }
        int length = Array.getLength(obj);
        Object[] retVal = new Object[length];
        for (int i = 0; i < length; ++i) {
            retVal[i] = Array.get(obj, i);
        }
        return retVal;
    }

    public static Option getCommOption(String sql, Object ... objects) {
        Url2SqlContext context = WebHelper.getContext();
        Map<String, String[]> map = context.getParams();
        if (sql.startsWith("$")) {
            sql = context.getUrlConfig().getVar(sql.substring(1));
        } else if (sql.length() <= 10) {
            sql = context.getUrlConfig().getVar(sql);
        }
        ArrayList<Object> values = new ArrayList<Object>();
        Matcher m = pattern.matcher(sql);
        StringBuffer sb = new StringBuffer();
        int index = 0;
        while (m.find()) {
            Object[] value = null;
            if ("?".equals(m.group(0))) {
                value = SqlHelperInstance.toObjectArray(objects[index]);
                ++index;
            } else {
                String key = m.group(1);
                if (key.toLowerCase().startsWith("session.")) {
                    Object temp = context.getSessionVal(key.substring(8));
                    if (temp == null) {
                        throw new SqlHelper.ParamNotExistException("${" + key + "} in session must exist.");
                    }
                    value = SqlHelperInstance.toObjectArray(temp);
                } else if (key.startsWith("~")) {
                    Object o = SqlHelperInstance.calcCustomTagValue(key.substring(1, key.length()));
                    value = SqlHelperInstance.toObjectArray(o);
                } else {
                    if (!map.containsKey(key)) {
                        throw new SqlHelper.ParamNotExistException("${" + key + "} must exist.");
                    }
                    value = SqlHelperInstance.toObjectArray(map.get(key));
                }
            }
            StringBuffer temp = new StringBuffer();
            for (Object s : value) {
                temp.append("?,");
                values.add(s);
            }
            temp.deleteCharAt(temp.length() - 1);
            m.appendReplacement(sb, temp.toString());
        }
        m.appendTail(sb);
        return new Option(sb.toString(), values.toArray());
    }

    public List<Model> query(String sql, Object ... objects) {
        Option o = SqlHelperInstance.getCommOption(sql, objects);
        return this.jdbcUtils.queryList(o.sql, o.values);
    }

    public PageView page(int currentpage, int pagesize, String sql, Object ... objects) {
        Option o = SqlHelperInstance.getCommOption(sql, objects);
        return this.jdbcUtils.page(currentpage, pagesize, o.sql, o.values);
    }

    public PageView page(String sql, Object ... objects) {
        Integer pagesize;
        Option o = SqlHelperInstance.getCommOption(sql, objects);
        Url2SqlContext c = WebHelper.getContext();
        Integer currentpage = c.getParamByType(Integer.class, "currentpage");
        if (currentpage == null) {
            currentpage = 1;
        }
        if ((pagesize = c.getParamByType(Integer.class, "pagesize")) == null) {
            pagesize = 10;
        }
        return this.jdbcUtils.page(currentpage, pagesize, o.sql, o.values);
    }

    public Model queryOne(String sql, Object ... objects) {
        Option o = SqlHelperInstance.getCommOption(sql, objects);
        return this.jdbcUtils.queryOne(o.sql, o.values);
    }

    public int execute(String sql, Object ... objects) {
        Option o = SqlHelperInstance.getCommOption(sql, objects);
        return this.jdbcUtils.execute(o.sql, o.values);
    }

    public Long executeGeneratedKey(String sql, Object ... objects) {
        Option o = SqlHelperInstance.getCommOption(sql, objects);
        return this.jdbcUtils.executeGeneratedKey(o.sql, o.values);
    }

    public List<String> alltables() {
        return this.jdbcUtils.getAllTables();
    }

    public static void main(String[] args) {
        WebHelper.init(null, null);
        SqlHelperInstance instance = new SqlHelperInstance();
        List<Model> a = instance.query("select * from student where id not in(${~uuid:yyyy})", new Object[0]);
        System.out.println(a);
        Url2SqlContext c = WebHelper.getContext();
        HashMap<String, String[]> m = new HashMap<String, String[]>();
        c.setParams(m);
        m.put("a.id", new String[]{"2"});
        m.put("a.name", new String[]{"gaollg"});
        List<Model> result = instance.query("select * from student where id=${a.id} and name like ?", "gaollg");
        System.out.println(result);
        m.clear();
        m.put("ids", new String[]{"1", "2", "3"});
        result = instance.query("select * from student where id in(${ids}) or id in(${~uuid})", new Object[0]);
        System.out.println(result);
        System.out.println("-----------------");
        result = instance.query("select * from student where id in(?) or id in(${~uuid})", new String[]{"1", "2", "3"}, 0);
        System.out.println(result);
        m.clear();
        m.put("name", new String[]{"Java"});
        m.put("age", new String[]{"44"});
        WebHelper.remove();
    }

    public static void main2(String[] args) {
        String a = "a?b?c?d?e?f?ghijklmn?";
        StringBuffer sb = new StringBuffer();
        String key = "?KEY&=";
        char[] array = a.toCharArray();
        for (int i = 0; i < array.length; ++i) {
            char c = array[i];
            if (c == '?') {
                sb.append(key + i);
                continue;
            }
            sb.append(c);
        }
        System.out.println(sb);
    }

    static {
        SqlHelperInstance.registCustomTag(new CustomTag(){

            @Override
            public Object invoke(String[] params) {
                return UUID.randomUUID().toString();
            }

            @Override
            public String getTagName() {
                return "uuid";
            }
        });
    }

    private static class Option {
        String sql;
        Object[] values;

        public Option(String sql, Object[] values) {
            this.sql = sql;
            this.values = values;
        }
    }

    public static interface CustomTag {
        public String getTagName();

        public Object invoke(String[] var1);
    }
}

