/*
 * Decompiled with CFR 0.152.
 */
package net.vsame.url2sql.helper;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.vsame.url2sql.helper.TypeConvertHelper;
import net.vsame.url2sql.render.Render;
import net.vsame.url2sql.url.impl.UrlConfig;
import net.vsame.url2sql.utils.JdbcUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Url2SqlContext {
    private static Log LOG = LogFactory.getLog(Url2SqlContext.class);
    private Connection conn;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private String extensionName;
    private String requestUrl;
    private Map<String, String[]> params;
    private UrlConfig urlConfig;
    private Map<String, Object> datas = new LinkedHashMap<String, Object>();
    private static ConnSource connSource;
    private HttpSession servletSession;
    private Map<String, Object> session;
    private Render render;
    private Object action;

    public Url2SqlContext() {
        this.datas.put("code", 0);
        this.datas.put("msg", "success");
    }

    public Connection getConn() {
        if (this.conn == null) {
            this.conn = connSource == null ? JdbcUtils.getConnection() : connSource.getConnection();
            try {
                this.conn.setAutoCommit(false);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.conn;
    }

    public void setConn(Connection conn) {
        this.conn = conn;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpSession getServletSession() {
        return this.servletSession;
    }

    public Map<String, Object> getSession() {
        if (this.session == null) {
            this.session = new HashMap<String, Object>();
            if (this.servletSession != null) {
                Enumeration e = this.servletSession.getAttributeNames();
                while (e.hasMoreElements()) {
                    String sessionName = (String)e.nextElement();
                    this.session.put(sessionName, this.servletSession.getAttribute(sessionName));
                }
            }
        }
        return this.session;
    }

    public void setSession(Map<String, Object> session) {
        this.session = session;
    }

    public <T> T getSessionValueToType(String key, Class<T> clazz) {
        Object o = this.getSession().get(key);
        if (o == null) {
            return null;
        }
        return (T)o;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
        if (request != null) {
            this.params = new HashMap<String, String[]>();
            this.params.putAll(request.getParameterMap());
            this.servletSession = request.getSession();
        }
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public String getExtensionName() {
        return this.extensionName;
    }

    public void setExtensionName(String extensionName) {
        this.extensionName = extensionName;
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public void setRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
    }

    public Map<String, String[]> getParams() {
        return this.params;
    }

    public String[] getParams(Object key) {
        return this.params.get(key + "");
    }

    public String getParam(Object key) {
        String[] array = this.params.get(key + "");
        if (array == null) {
            return null;
        }
        return array[0];
    }

    public void setParams(Map<String, String[]> params) {
        this.params = params;
    }

    public Render getRender() {
        return this.render;
    }

    public void setRender(Render render) {
        this.render = render;
    }

    public Object getAction() {
        return this.action;
    }

    public <T> T getParamByType(Class<T> clazz, String key) {
        if (!clazz.isArray()) {
            return TypeConvertHelper.parseType(clazz, (Object)this.getParam(key));
        }
        String[] params = this.getParams(key);
        if (params == null || params.length == 0) {
            return null;
        }
        Class<?> componentType = clazz.getComponentType();
        Object[] a = (Object[])Array.newInstance(componentType, params.length);
        for (int i = 0; i < params.length; ++i) {
            a[i] = TypeConvertHelper.parseType(componentType, (Object)params[i]);
        }
        return (T)a;
    }

    public UrlConfig getUrlConfig() {
        return this.urlConfig;
    }

    public void setUrlConfig(UrlConfig urlConfig) {
        this.urlConfig = urlConfig;
        Method m = urlConfig.getMethod();
        if (m == null) {
            return;
        }
        try {
            this.action = m.getDeclaringClass().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public Map<String, Object> getDatas() {
        return this.datas;
    }

    public boolean hasError() {
        return !this.datas.get("code").equals(0);
    }

    public void putUsefulData(String key, Object value) {
        this.datas.put(key, value);
    }

    public void put(String key, Object value) {
        this.datas.put(key, value);
    }

    public void putError(int code, String msg, boolean clean) {
        if (clean) {
            this.datas.clear();
        }
        this.datas.put("code", code);
        this.datas.put("msg", msg);
    }

    public void putError(int code, String msg) {
        this.putError(code, msg, true);
    }

    public void error(Exception e, String errorMsg) {
        LOG.error((Object)"error:", (Throwable)e);
        if (errorMsg == null) {
            errorMsg = "500:" + e.getMessage();
        }
        this.putError(-1, errorMsg);
    }

    public void putFormError(String msg, Map<String, String> errors) {
        if (msg == null) {
            msg = "Form has " + errors.keySet().size() + "Errors";
        }
        this.putError(-2, msg);
        this.putUsefulData("errors", errors);
    }

    public void putFormError(Map<String, String> errors) {
        this.putError(-2, null);
        this.putUsefulData("errors", errors);
    }

    public void putNoPermission() {
        this.putError(-3, "No Permission!");
    }

    public void putBanIP(String msg) {
        if (msg == null) {
            msg = "";
        }
        this.putError(-4, "Ban IP visit!" + msg);
    }

    public void put404() {
        this.putError(-5, "Api not exist!");
    }

    public void putBusy() {
        this.putError(-6, "Access frequency transfinite!");
    }

    public void putNoLogin() {
        this.putError(1, "Please Login!");
    }

    private static String firstLetterToUpper(String string) {
        char[] buffer = string.toCharArray();
        buffer[0] = Character.toUpperCase(string.charAt(0));
        return new String(buffer);
    }

    public Object getSessionVal(String str) {
        String[] keys = str.split("\\.");
        Object o = this.getSession().get(keys[0]);
        for (int i = 1; i < keys.length; ++i) {
            String now = keys[i];
            if (o instanceof Map) {
                Map m = (Map)o;
                o = m.get(now);
                continue;
            }
            Class<?> clazz = o.getClass();
            try {
                Method m = clazz.getMethod("get" + Url2SqlContext.firstLetterToUpper(now), new Class[0]);
                o = m.invoke(o, new Object[0]);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.conn != null) {
            try {
                try {
                    this.conn.commit();
                }
                finally {
                    this.conn.close();
                }
            }
            catch (Exception e) {}
        }
        if (this.servletSession != null && this.session != null) {
            Enumeration e = this.servletSession.getAttributeNames();
            while (e.hasMoreElements()) {
                String sessionName = (String)e.nextElement();
                Object o = this.session.get(sessionName);
                if (o != null) {
                    this.servletSession.setAttribute(sessionName, o);
                    this.session.remove(sessionName);
                    continue;
                }
                this.servletSession.removeAttribute(sessionName);
            }
            for (Map.Entry<String, Object> entry : this.session.entrySet()) {
                this.servletSession.setAttribute(entry.getKey(), entry.getValue());
            }
        }
    }

    public static ConnSource getConnSource() {
        return connSource;
    }

    public static void setConnSource(ConnSource connSource) {
        Url2SqlContext.connSource = connSource;
    }

    public static interface ConnSource {
        public Connection getConnection();
    }
}

