/*
 * Decompiled with CFR 0.152.
 */
package net.vsame.url2sql.url.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.servlet.ServletContext;
import net.vsame.url2sql.helper.SqlHelper;
import net.vsame.url2sql.helper.Url2SqlContext;
import net.vsame.url2sql.helper.WebHelper;
import net.vsame.url2sql.url.Interceptor;
import net.vsame.url2sql.url.impl.UrlConfig;
import net.vsame.url2sql.url.impl.UrlMapping;

public class ActionInterceptor
implements Interceptor {
    private static Invocable jsFunction = null;

    private static void loadResource(ScriptEngine engine, String resource) {
        InputStreamReader scriptReader = new InputStreamReader(ActionInterceptor.class.getResourceAsStream(resource), Charset.forName("utf-8"));
        try {
            engine.eval(scriptReader);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                ((Reader)scriptReader).close();
            }
            catch (IOException e) {}
        }
    }

    public static void resetJsInvocable() {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName("JavaScript");
        ActionInterceptor.loadResource(engine, "/core.js");
        if (!(engine instanceof Invocable)) {
            throw new RuntimeException("not suppont!");
        }
        jsFunction = (Invocable)((Object)engine);
    }

    @Override
    public void init(UrlMapping urlMapping, ServletContext servletContext) {
    }

    @Override
    public void invoke(UrlMapping.Chain chain) {
        Url2SqlContext c = WebHelper.getContext();
        UrlConfig u = c.getUrlConfig();
        Method m = u.getMethod();
        if (m != null) {
            try {
                m.invoke(c.getAction(), new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getCause());
            }
        } else {
            this.executeJs();
        }
    }

    @Override
    public void destroy() {
    }

    public void executeJs() {
        ArrayList errors = new ArrayList();
        try {
            Url2SqlContext c = WebHelper.getContext();
            UrlConfig urlConfig = c.getUrlConfig();
            String json = "var vars=" + JSON.toJSONString(urlConfig.getVars(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}) + ";";
            jsFunction.invokeFunction("execute", json + urlConfig.getJs(), c, errors);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!errors.isEmpty()) {
            throw new RuntimeException((String)errors.get(0));
        }
    }

    public static void main(String[] args) {
        Url2SqlContext c = WebHelper.getContext();
        UrlConfig urlConfig = new UrlConfig();
        c.setUrlConfig(urlConfig);
        c.setParams(new HashMap<String, String[]>());
        urlConfig.setJs("println('=========================');context.put('a', 'b');context.put('page', SQL.page('select *', 'from student', '1'));context.put('page', SQL.alltables());context.put('queryAllResult', SqlHelper.query('select * from student where id in(?)', [4,2,3]));");
        new ActionInterceptor().executeJs();
        System.out.println(c.getDatas());
        SqlHelper.class.getMethods();
    }

    static {
        ActionInterceptor.resetJsInvocable();
    }
}

