/*
 * Decompiled with CFR 0.152.
 */
package net.vsame.url2sql.url.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import net.vsame.url2sql.config.ConfigFactory;
import net.vsame.url2sql.helper.SqlHelper;
import net.vsame.url2sql.helper.Url2SqlContext;
import net.vsame.url2sql.helper.WebHelper;
import net.vsame.url2sql.render.JsonRender;
import net.vsame.url2sql.render.Render;
import net.vsame.url2sql.url.Interceptor;
import net.vsame.url2sql.url.impl.ActionInterceptor;
import net.vsame.url2sql.url.impl.UrlConfig;

public class UrlMapping {
    private static UrlMapping mapping = new UrlMapping();
    private Map<String, UrlConfig> urlSqlMap = new HashMap<String, UrlConfig>();
    private Map<String, Render> renderMap = new HashMap<String, Render>();
    private List<Interceptor> interceptors = new ArrayList<Interceptor>();

    private UrlMapping() {
    }

    public static UrlMapping getMapping() {
        return mapping;
    }

    public Map<String, UrlConfig> getUrlSqlMap() {
        return this.urlSqlMap;
    }

    public UrlConfig getConfig(String url) {
        if (!url.startsWith("/")) {
            url = "/" + url;
        }
        return this.urlSqlMap.get(url);
    }

    public void addUrlConfig(UrlConfig urlConfig) {
        this.urlSqlMap.put(urlConfig.getUrl(), urlConfig);
    }

    public void addUrlConfig(Map<String, UrlConfig> map) {
        this.urlSqlMap.putAll(map);
    }

    public void addInterceptor(Interceptor i) {
        this.interceptors.add(i);
    }

    public void addInterceptor(List<Interceptor> is) {
        this.interceptors.addAll(is);
    }

    public void registRender(String expandedName, Render render) {
        expandedName = expandedName.replace(".", "");
        this.renderMap.put(expandedName, render);
    }

    public Render findRender(String expandedName) {
        return this.renderMap.get(expandedName);
    }

    public void reload(ServletContext servletContext) {
        this.urlSqlMap.clear();
        this.interceptors.clear();
        this.renderMap.clear();
        this.registRender("json", new JsonRender());
        ConfigFactory.load(mapping);
        this.interceptors.add(new ActionInterceptor());
        for (Interceptor i : this.interceptors) {
            i.init(this, servletContext);
        }
    }

    public void destroy() {
        for (Interceptor i : this.interceptors) {
            i.destroy();
        }
    }

    public void invoke() {
        try {
            new Chain().next();
        }
        catch (Exception e) {
            String msg = null;
            msg = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            Url2SqlContext c = WebHelper.getContext();
            if (e instanceof SqlHelper.ParamNotExistException) {
                c.putError(-2, msg);
            } else {
                c.error(e, msg);
            }
            try {
                c.getConn().rollback();
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
    }

    public class Chain {
        private int i = -1;

        public void next() {
            ++this.i;
            if (this.i < UrlMapping.this.interceptors.size()) {
                ((Interceptor)UrlMapping.this.interceptors.get(this.i)).invoke(this);
            }
        }
    }
}

