/*
 * Decompiled with CFR 0.152.
 */
package network.aika.debugger;

import java.awt.Color;
import java.io.Serializable;
import java.util.function.Consumer;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import network.aika.neuron.Neuron;
import network.aika.neuron.Synapse;
import network.aika.neuron.activation.Reference;
import network.aika.neuron.excitatory.PatternPartSynapse;
import network.aika.neuron.sign.Sign;
import network.aika.utils.Utils;

public abstract class AbstractConsole
extends JTextPane {
    public AbstractConsole() {
        this.addStylesToDocument(this.getStyledDocument());
        this.setEditable(false);
    }

    public void render(String headline, Consumer<StyledDocument> content) {
        this.setDoubleBuffered(true);
        this.setOpaque(false);
        this.setEnabled(false);
        this.setVisible(false);
        DefaultStyledDocument sDoc = new DefaultStyledDocument();
        this.addStylesToDocument(sDoc);
        this.clear();
        this.addHeadline(sDoc, headline);
        content.accept(sDoc);
        this.setStyledDocument(sDoc);
        this.setVisible(true);
        this.setEnabled(true);
    }

    public void addStylesToDocument(StyledDocument doc) {
        Color green = new Color(0, 130, 0);
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        StyleConstants.setFontFamily(def, "SansSerif");
        Style regular = doc.addStyle("regular", def);
        StyleConstants.setFontSize(regular, 10);
        Style regularGreen = doc.addStyle("regularGreen", def);
        StyleConstants.setFontSize(regularGreen, 10);
        StyleConstants.setForeground(regularGreen, green);
        Style s = doc.addStyle("italic", regular);
        StyleConstants.setItalic(s, true);
        s = doc.addStyle("bold", regular);
        StyleConstants.setBold(s, true);
        s = doc.addStyle("boldGreen", regular);
        StyleConstants.setBold(s, true);
        StyleConstants.setForeground(s, green);
        s = doc.addStyle("small", regular);
        StyleConstants.setFontSize(s, 10);
        s = doc.addStyle("headline", regular);
        StyleConstants.setFontSize(s, 14);
    }

    public void clear() {
        StyledDocument sDoc = this.getStyledDocument();
        try {
            sDoc.remove(0, sDoc.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public String getRoundStr(int round) {
        return Integer.MAX_VALUE == round ? "MAX" : "" + round;
    }

    public void renderNeuronConsoleOutput(StyledDocument sDoc, Neuron n, Reference ref) {
        this.appendText(sDoc, "Neuron\n\n", "headline");
        this.appendEntry(sDoc, "Id: ", "" + n.getId());
        this.appendEntry(sDoc, "Label: ", n.getLabel());
        this.appendEntry(sDoc, "Type: ", n.getClass().getSimpleName());
        this.appendEntry(sDoc, "Is Input Neuron: ", "" + n.isInputNeuron());
        this.appendEntry(sDoc, "Bias: ", "" + Utils.round((double)n.getBias(false)));
        this.appendEntry(sDoc, "Bias (final): ", "" + Utils.round((double)n.getBias(true)));
        if (!n.isTemplate()) {
            this.appendEntry(sDoc, "Frequency: ", "" + Utils.round((double)n.getFrequency()));
            this.appendEntry(sDoc, "N: ", "" + Utils.round((double)n.getSampleSpace().getN(ref)));
            this.appendEntry(sDoc, "LastPos: ", "" + (Serializable)(n.getSampleSpace().getLastPos() != null ? Double.valueOf(Utils.round((double)n.getSampleSpace().getLastPos().intValue())) : "X"));
            this.appendEntry(sDoc, "P(POS): ", "" + Utils.round((double)n.getP((Sign)Sign.POS, n.getSampleSpace().getN(ref))));
            this.appendEntry(sDoc, "P(NEG): ", "" + Utils.round((double)n.getP((Sign)Sign.NEG, n.getSampleSpace().getN(ref))));
            this.appendEntry(sDoc, "Surprisal(POS): ", "" + Utils.round((double)n.getSurprisal((Sign)Sign.POS, ref)));
            this.appendEntry(sDoc, "Surprisal(NEG): ", "" + Utils.round((double)n.getSurprisal((Sign)Sign.NEG, ref)));
            this.appendEntry(sDoc, "Template Neuron: ", this.templatesToString(n));
        }
    }

    private String templatesToString(Neuron<?> n) {
        StringBuilder sb = new StringBuilder();
        n.getTemplates().forEach(tn -> sb.append(tn.getId() + ":" + tn.getLabel() + ", "));
        return sb.toString();
    }

    public void renderSynapseConsoleOutput(StyledDocument sDoc, Synapse s, Reference ref) {
        this.appendText(sDoc, "Synapse\n\n", "headline");
        this.appendEntry(sDoc, "Type: ", s.getClass().getSimpleName());
        this.appendEntry(sDoc, "Weight: ", "" + Utils.round((double)s.getWeight()));
        this.appendEntry(sDoc, "Input: ", s.getInput().toString());
        this.appendEntry(sDoc, "Output: ", s.getOutput().toString());
        if (s instanceof PatternPartSynapse) {
            PatternPartSynapse pps = (PatternPartSynapse)s;
            this.appendEntry(sDoc, "InputScope: ", "" + pps.isInputScope());
            this.appendEntry(sDoc, "SamePattern: ", "" + pps.isSamePattern());
            this.appendEntry(sDoc, "Recurrent: ", "" + pps.isRecurrent());
            this.appendEntry(sDoc, "is Negative: ", "" + pps.isNegative());
        }
        this.appendEntry(sDoc, "Frequency(POS, POS): ", "" + Utils.round((double)s.getFrequency((Sign)Sign.POS, (Sign)Sign.POS, s.getSampleSpace().getN(ref))));
        this.appendEntry(sDoc, "Frequency(POS, NEG): ", "" + Utils.round((double)s.getFrequency((Sign)Sign.POS, (Sign)Sign.NEG, s.getSampleSpace().getN(ref))));
        this.appendEntry(sDoc, "Frequency(NEG, POS): ", "" + Utils.round((double)s.getFrequency((Sign)Sign.NEG, (Sign)Sign.POS, s.getSampleSpace().getN(ref))));
        this.appendEntry(sDoc, "Frequency(NEG, NEG): ", "" + Utils.round((double)s.getFrequency((Sign)Sign.NEG, (Sign)Sign.NEG, s.getSampleSpace().getN(ref))));
        this.appendEntry(sDoc, "N: ", "" + Utils.round((double)s.getSampleSpace().getN(ref)));
        this.appendEntry(sDoc, "LastPos: ", "" + (Serializable)(s.getSampleSpace().getLastPos() != null ? Double.valueOf(Utils.round((double)s.getSampleSpace().getLastPos().intValue())) : "X"));
        this.appendEntry(sDoc, "P(POS, POS) :", "" + Utils.round((double)s.getP((Sign)Sign.POS, (Sign)Sign.POS, s.getSampleSpace().getN(ref))));
        this.appendEntry(sDoc, "P(POS, NEG) :", "" + Utils.round((double)s.getP((Sign)Sign.POS, (Sign)Sign.NEG, s.getSampleSpace().getN(ref))));
        this.appendEntry(sDoc, "P(NEG, POS) :", "" + Utils.round((double)s.getP((Sign)Sign.NEG, (Sign)Sign.POS, s.getSampleSpace().getN(ref))));
        this.appendEntry(sDoc, "P(NEG, NEG) :", "" + Utils.round((double)s.getP((Sign)Sign.NEG, (Sign)Sign.NEG, s.getSampleSpace().getN(ref))));
        this.appendEntry(sDoc, "Surprisal(POS, POS): ", "" + Utils.round((double)s.getSurprisal((Sign)Sign.POS, (Sign)Sign.POS, ref)));
        this.appendEntry(sDoc, "Surprisal(POS, NEG): ", "" + Utils.round((double)s.getSurprisal((Sign)Sign.POS, (Sign)Sign.NEG, ref)));
        this.appendEntry(sDoc, "Surprisal(NEG, POS): ", "" + Utils.round((double)s.getSurprisal((Sign)Sign.NEG, (Sign)Sign.POS, ref)));
        this.appendEntry(sDoc, "Surprisal(NEG, NEG): ", "" + Utils.round((double)s.getSurprisal((Sign)Sign.NEG, (Sign)Sign.NEG, ref)));
        this.appendEntry(sDoc, "Template: ", s.getTemplate() != null ? s.getTemplate().toString() : null);
    }

    public void appendEntry(StyledDocument sDoc, String fieldName, String fieldValue) {
        this.appendEntry(sDoc, fieldName, fieldValue, "bold", "regular");
    }

    public void appendEntry(StyledDocument sDoc, String fieldName, String fieldValue, String titleStyle, String style) {
        this.appendText(sDoc, fieldName, titleStyle);
        this.appendText(sDoc, fieldValue + "\n", style);
    }

    protected void appendText(StyledDocument sDoc, String txt, String style) {
        try {
            sDoc.insertString(sDoc.getLength(), txt, sDoc.getStyle(style));
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void addHeadline(StyledDocument sDoc, String headline) {
        this.appendText(sDoc, headline + "\n\n", "headline");
    }
}

