/*
 * Decompiled with CFR 0.152.
 */
package network.aika.debugger;

import java.util.Iterator;
import network.aika.debugger.AbstractLayout;
import org.graphstream.ui.geom.Vector3;
import org.graphstream.ui.layout.springbox.EdgeSpring;
import org.graphstream.ui.layout.springbox.Energies;
import org.graphstream.ui.layout.springbox.GraphCellData;
import org.graphstream.ui.layout.springbox.NodeParticle;
import org.graphstream.ui.layout.springbox.implementations.SpringBox;
import org.graphstream.ui.layout.springbox.implementations.SpringBoxNodeParticle;
import org.miv.pherd.ParticleBox;
import org.miv.pherd.geom.Point3;
import org.miv.pherd.ntree.Cell;

public abstract class AbstractParticle
extends SpringBoxNodeParticle {
    public static double K1Attr = 1.0E-4;
    public double x;
    public double y;
    protected double K2 = 5.0E-6f;

    public AbstractParticle(AbstractLayout layout, String id, double x, double y, double z) {
        super((SpringBox)layout, id, x, y, z);
    }

    protected void repulsionN2(Vector3 delta) {
        AbstractLayout box = (AbstractLayout)this.box;
        boolean is3D = box.is3D();
        ParticleBox nodes = box.getSpatialIndex();
        Energies energies = box.getEnergies();
        Iterator i = nodes.getParticleIdIterator();
        while (i.hasNext()) {
            AbstractParticle node = (AbstractParticle)nodes.getParticle(i.next());
            if (node == this) continue;
            delta.set(node.pos.x - this.pos.x, 0.0, 0.0);
            double len = delta.normalize();
            if (!(len > 0.0)) continue;
            if (len < AbstractLayout.k) {
                len = AbstractLayout.k;
            }
            double factor = this.K2 / (len * len) * node.weight;
            energies.accumulateEnergy(factor);
            delta.scalarMult(-factor);
            this.disp.add(delta);
        }
    }

    protected void repulsionNLogN(Vector3 delta) {
        this.recurseRepulsion(this.box.getSpatialIndex().getNTree().getRootCell(), delta);
    }

    protected void recurseRepulsion(Cell cell, Vector3 delta) {
        AbstractLayout box = (AbstractLayout)this.box;
        boolean is3D = box.is3D();
        Energies energies = box.getEnergies();
        if (this.intersection(cell)) {
            if (cell.isLeaf()) {
                Iterator i = cell.getParticles();
                while (i.hasNext()) {
                    AbstractParticle node = (AbstractParticle)((Object)i.next());
                    if (node == this) continue;
                    delta.set(node.pos.x - this.pos.x, 0.0, 0.0);
                    double len = delta.normalize();
                    if (!(len > 0.0)) continue;
                    if (len < AbstractLayout.k) {
                        len = AbstractLayout.k;
                    }
                    double factor = this.K2 / (len * len) * node.weight;
                    energies.accumulateEnergy(factor);
                    this.repE += factor;
                    delta.scalarMult(-factor);
                    this.disp.add(delta);
                }
            } else {
                int div = cell.getSpace().getDivisions();
                for (int i = 0; i < div; ++i) {
                    this.recurseRepulsion(cell.getSub(i), delta);
                }
            }
        } else if (cell != this.cell) {
            GraphCellData bary = (GraphCellData)cell.getData();
            double dist = bary.distanceFrom(this.pos);
            double size = cell.getSpace().getSize();
            if (!cell.isLeaf() && size / dist > box.getBarnesHutTheta()) {
                int div = cell.getSpace().getDivisions();
                for (int i = 0; i < div; ++i) {
                    this.recurseRepulsion(cell.getSub(i), delta);
                }
            } else if (bary.weight != 0.0) {
                delta.set(bary.center.x - this.pos.x, 0.0, 0.0);
                double len = delta.normalize();
                if (len > 0.0) {
                    if (len < AbstractLayout.k) {
                        len = AbstractLayout.k;
                    }
                    double factor = this.K2 / (len * len) * bary.weight;
                    energies.accumulateEnergy(factor);
                    delta.scalarMult(-factor);
                    this.repE += factor;
                    this.disp.add(delta);
                }
            }
        }
    }

    protected void edgeAttraction(Vector3 delta, EdgeSpring edge, Energies energies) {
        int neighbourCount = this.neighbours.size();
        NodeParticle other = edge.getOpposite((NodeParticle)this);
        Point3 opos = other.getPosition();
        delta.set(opos.x - this.pos.x, opos.y - this.pos.y, 0.0);
        double len = delta.normalize();
        double factor = K1Attr;
        delta.scalarMult(factor * (double)(1.0f / ((float)neighbourCount * 0.1f)));
        this.disp.add(delta);
        this.attE += factor;
        energies.accumulateEnergy(factor);
    }
}

