/*
 * Decompiled with CFR 0.152.
 */
package network.aika.debugger;

import java.awt.Component;
import java.awt.event.MouseWheelListener;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import network.aika.debugger.AbstractConsole;
import network.aika.debugger.AbstractGraphManager;
import network.aika.debugger.MouseManager;
import network.aika.neuron.Neuron;
import network.aika.neuron.Synapse;
import network.aika.neuron.excitatory.PatternNeuron;
import network.aika.neuron.excitatory.PatternPartNeuron;
import network.aika.neuron.excitatory.PatternPartSynapse;
import network.aika.neuron.excitatory.PatternSynapse;
import network.aika.neuron.inhibitory.InhibitoryNeuron;
import network.aika.neuron.inhibitory.InhibitorySynapse;
import network.aika.neuron.inhibitory.PrimaryInhibitorySynapse;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Element;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.SingleGraph;
import org.graphstream.stream.ProxyPipe;
import org.graphstream.stream.Sink;
import org.graphstream.stream.Source;
import org.graphstream.stream.thread.ThreadProxyPipe;
import org.graphstream.ui.graphicGraph.GraphicElement;
import org.graphstream.ui.swing.SwingGraphRenderer;
import org.graphstream.ui.swing_viewer.DefaultView;
import org.graphstream.ui.swing_viewer.SwingViewer;
import org.graphstream.ui.swing_viewer.ViewPanel;
import org.graphstream.ui.view.GraphRenderer;
import org.graphstream.ui.view.Viewer;
import org.graphstream.ui.view.ViewerListener;
import org.graphstream.ui.view.ViewerPipe;
import org.graphstream.ui.view.camera.Camera;

public abstract class AbstractViewManager<C extends AbstractConsole, G extends AbstractGraphManager>
implements ViewerListener {
    protected Map<Class<? extends Neuron>, Consumer<Node>> neuronTypeModifiers = new HashMap<Class<? extends Neuron>, Consumer<Node>>();
    protected Map<Class<? extends Synapse>, BiConsumer<Edge, Synapse>> synapseTypeModifiers = new HashMap<Class<? extends Synapse>, BiConsumer<Edge, Synapse>>();
    protected Graph graph;
    protected G graphManager;
    protected SwingViewer viewer;
    protected ViewerPipe fromViewer;
    protected ViewPanel graphView;
    protected JSplitPane splitPane;
    protected C console;
    protected Element lastHighlighted;

    public AbstractViewManager() {
        this.initModifiers();
        this.graph = this.initGraph();
        this.viewer = new SwingViewer((ProxyPipe)new ThreadProxyPipe((Source)this.graph));
        this.graphView = (DefaultView)this.viewer.addDefaultView(false, (GraphRenderer)new SwingGraphRenderer());
        this.graphView.enableMouseOptions();
        MouseManager mouseManager = new MouseManager(this);
        this.graphView.setMouseManager((org.graphstream.ui.view.util.MouseManager)mouseManager);
        this.graphView.addMouseWheelListener((MouseWheelListener)mouseManager);
        Camera camera = this.graphView.getCamera();
        camera.setAutoFitView(false);
        this.viewer.setCloseFramePolicy(Viewer.CloseFramePolicy.HIDE_ONLY);
        this.fromViewer = this.viewer.newViewerPipe();
        this.fromViewer.addViewerListener((ViewerListener)this);
        this.fromViewer.addSink((Sink)this.graph);
    }

    public G getGraphManager() {
        return this.graphManager;
    }

    public abstract void showElementContext(String var1, GraphicElement var2);

    public Graph getGraph() {
        return this.graph;
    }

    public Camera getCamera() {
        return this.graphView.getCamera();
    }

    public JSplitPane getView() {
        return this.splitPane;
    }

    public C getConsole() {
        return this.console;
    }

    protected JSplitPane initSplitPane() {
        JSplitPane splitPane = new JSplitPane(1, (Component)this.graphView, this.getConsolePane());
        splitPane.setOneTouchExpandable(true);
        splitPane.setResizeWeight(0.7);
        return splitPane;
    }

    public abstract JComponent getConsolePane();

    private Graph initGraph() {
        SingleGraph graph = new SingleGraph("0");
        graph.setAttribute("ui.stylesheet", new Object[]{"node {size: 20px;z-index: 1;stroke-mode: plain; stroke-width: 2px;text-size: 20px;text-alignment: under;text-color: black;text-style: bold;text-background-mode: rounded-box;text-background-color: rgba(100, 100, 100, 100); text-padding: 2px;text-offset: 0px, 2px;} node:selected {stroke-color: red; stroke-width: 4px;} edge {size: 2px;shape: cubic-curve;z-index: 0;arrow-size: 8px, 5px;} edge:selected {stroke-mode: plain; fill-color: red;stroke-width: 3px;}"});
        graph.setAttribute("ui.antialias", new Object[0]);
        graph.setAutoCreate(true);
        return graph;
    }

    protected void initModifiers() {
        this.neuronTypeModifiers.put(PatternNeuron.class, n -> n.setAttribute("ui.style", new Object[]{"fill-color: rgb(0,130,0);"}));
        this.neuronTypeModifiers.put(PatternPartNeuron.class, n -> n.setAttribute("ui.style", new Object[]{"fill-color: rgb(0,205,0);"}));
        this.neuronTypeModifiers.put(InhibitoryNeuron.class, n -> n.setAttribute("ui.style", new Object[]{"fill-color: rgb(100,100,255);"}));
        this.synapseTypeModifiers.put(PatternPartSynapse.class, (e, s) -> {
            PatternPartSynapse pps = (PatternPartSynapse)s;
            if (pps.isRecurrent()) {
                e.setAttribute("ui.style", new Object[]{"fill-color: rgb(104,34,139);"});
            } else if (pps.isNegative()) {
                e.setAttribute("ui.style", new Object[]{"fill-color: rgb(100,0,0);"});
            }
            if (pps.isInputScope()) {
                e.setAttribute("ui.style", new Object[]{"fill-color: rgb(50,200,50);"});
            } else {
                e.setAttribute("ui.style", new Object[]{"fill-color: rgb(0,130,0);"});
            }
        });
        this.synapseTypeModifiers.put(InhibitorySynapse.class, (e, s) -> e.setAttribute("ui.style", new Object[]{"fill-color: rgb(50,50,150);"}));
        this.synapseTypeModifiers.put(PrimaryInhibitorySynapse.class, (e, s) -> e.setAttribute("ui.style", new Object[]{"fill-color: rgb(0,00,100);"}));
        this.synapseTypeModifiers.put(PatternSynapse.class, (e, s) -> e.setAttribute("ui.style", new Object[]{"fill-color: rgb(0,130,0);"}));
    }

    public void pump() {
        this.fromViewer.pump();
    }

    public void unhighlightElement(Element ge) {
        ge.removeAttribute("ui.selected");
        this.fromViewer.pump();
    }

    public void highlightElement(Element ge) {
        ge.setAttribute("ui.selected", new Object[0]);
        this.fromViewer.pump();
    }

    public void viewClosed(String id) {
    }

    public void buttonPushed(String id) {
        System.out.println("Button pushed on node " + id);
    }

    public void buttonReleased(String id) {
        System.out.println("Button released on node " + id);
    }

    public void mouseOver(String id) {
        System.out.println("Need the Mouse Options to be activated");
    }

    public void mouseLeft(String id) {
        System.out.println("Need the Mouse Options to be activated");
    }

    public abstract void click(int var1, int var2);
}

