/*
 * Decompiled with CFR 0.152.
 */
package network.aika.debugger;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import network.aika.Model;
import network.aika.debugger.KeyManager;
import network.aika.debugger.activations.ActivationViewManager;
import network.aika.debugger.neurons.NeuronViewManager;
import network.aika.debugger.neurons.templates.TemplateViewManager;
import network.aika.text.Document;

public class AikaDebugger
extends JPanel {
    JTabbedPane tabbedPane;
    Document doc;
    Model model;
    ActivationViewManager actViewManager;
    NeuronViewManager neuronViewManager;
    TemplateViewManager templateViewManager;
    KeyManager keyManager;
    static final Integer ACTIVATION_TAB_INDEX = 0;
    static final Integer NEURON_TAB_INDEX = 1;
    static final Integer TEMPLATE_TAB_INDEX = 2;

    public AikaDebugger(Document doc, Model model) {
        super(new GridLayout(1, 1));
        this.doc = doc;
        this.model = model;
        this.tabbedPane = new JTabbedPane();
        this.add(this.tabbedPane);
        this.tabbedPane.setTabLayoutPolicy(1);
        this.tabbedPane.setFocusCycleRoot(true);
        this.tabbedPane.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                System.out.println("Click");
            }

            @Override
            public void mousePressed(MouseEvent e) {
                System.out.println();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                System.out.println();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.actViewManager = new ActivationViewManager(doc);
        this.neuronViewManager = new NeuronViewManager(model, doc);
        this.templateViewManager = new TemplateViewManager(model);
        this.keyManager = new KeyManager(this.actViewManager);
        this.addTab(ACTIVATION_TAB_INDEX, "Activations", 65, this.actViewManager.getView());
        this.addTab(NEURON_TAB_INDEX, "Neurons", 78, this.neuronViewManager.getView());
        this.addTab(TEMPLATE_TAB_INDEX, "Templates", 78, this.templateViewManager.getView());
        this.tabbedPane.addKeyListener(this.keyManager);
        this.tabbedPane.addChangeListener(event -> {
            if (this.tabbedPane.getSelectedIndex() == NEURON_TAB_INDEX.intValue()) {
                this.neuronViewManager.initGraphNeurons();
            } else if (this.tabbedPane.getSelectedIndex() == TEMPLATE_TAB_INDEX.intValue()) {
                this.templateViewManager.initGraphNeurons();
            }
        });
    }

    public void addTab(int tabIndex, String label, int ke, JComponent panel) {
        this.tabbedPane.addTab(label, null, panel, "Does nothing");
        this.tabbedPane.setMnemonicAt(tabIndex, ke);
    }

    public static void createAndShowGUI(Document doc, Model model) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        JFrame frame = new JFrame("Aika Debugger");
        frame.setDefaultCloseOperation(3);
        frame.add((Component)new AikaDebugger(doc, model), "Center");
        frame.setVisible(true);
        frame.setExtendedState(frame.getExtendedState() | 6);
    }
}

