/*
 * Decompiled with CFR 0.152.
 */
package network.aika.debugger;

import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.EnumSet;
import javax.swing.event.MouseInputListener;
import network.aika.debugger.AbstractGraphManager;
import network.aika.debugger.AbstractParticle;
import network.aika.debugger.AbstractViewManager;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Node;
import org.graphstream.ui.geom.Point3;
import org.graphstream.ui.graphicGraph.GraphicEdge;
import org.graphstream.ui.graphicGraph.GraphicElement;
import org.graphstream.ui.graphicGraph.GraphicGraph;
import org.graphstream.ui.view.View;
import org.graphstream.ui.view.camera.Camera;
import org.graphstream.ui.view.camera.DefaultCamera2D;
import org.graphstream.ui.view.util.InteractiveElement;

public class MouseManager
implements MouseInputListener,
org.graphstream.ui.view.util.MouseManager,
MouseWheelListener {
    protected View view;
    protected GraphicGraph graph;
    private final EnumSet<InteractiveElement> types;
    protected GraphicElement curElement;
    private AbstractViewManager viewManager;
    private MouseEvent lastMouseDragEvent;

    public MouseManager(AbstractViewManager viewManager) {
        this(EnumSet.of(InteractiveElement.NODE, InteractiveElement.SPRITE));
        this.viewManager = viewManager;
    }

    public MouseManager(EnumSet<InteractiveElement> types) {
        this.types = types;
    }

    public void init(GraphicGraph graph, View view) {
        this.view = view;
        this.graph = graph;
        view.addListener((Object)"Mouse", (Object)this);
        view.addListener((Object)"MouseMotion", (Object)this);
    }

    public EnumSet<InteractiveElement> getManagedTypes() {
        return this.types;
    }

    public void release() {
        this.view.removeListener((Object)"Mouse", (Object)this);
        this.view.removeListener((Object)"MouseMotion", (Object)this);
    }

    protected void mouseButtonPressOnElement(GraphicElement element, MouseEvent event) {
        this.view.freezeElement(element, true);
        if (event.getButton() == 3) {
            element.setAttribute("ui.selected", new Object[0]);
        } else {
            element.setAttribute("ui.clicked", new Object[0]);
            this.viewManager.showElementContext("Selected", element);
        }
    }

    protected void elementMoving(GraphicElement element, MouseEvent event) {
        this.view.moveElementAtPx(element, (double)event.getX(), (double)event.getY());
    }

    protected void mouseButtonReleaseOffElement(GraphicElement element, MouseEvent event) {
        this.view.freezeElement(element, false);
        if (event.getButton() != 3) {
            element.removeAttribute("ui.clicked");
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        this.viewManager.click(event.getX(), event.getY());
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (!event.isShiftDown()) {
            this.curElement = this.view.findGraphicElementAt(this.types, (double)event.getX(), (double)event.getY());
            if (this.curElement == null) {
                float x = event.getX();
                float y = event.getY();
                Camera camera = this.view.getCamera();
                Point3 pointGU = camera.transformPxToGu((double)x, (double)y);
                GraphicEdge selectedEdge = this.graph.edges().filter(e -> this.withinEdgeBoundingBox((Edge)e, pointGU)).filter(e -> this.edgeSelected((Edge)e, pointGU)).findAny().orElse(null);
                this.curElement = selectedEdge;
            }
            if (this.curElement != null) {
                this.mouseButtonPressOnElement(this.curElement, event);
            }
        }
    }

    private boolean withinEdgeBoundingBox(Edge e, Point3 pointGU) {
        double[] ps = this.getCoords(e.getSourceNode());
        double[] pt = this.getCoords(e.getTargetNode());
        double minX = Math.min(ps[0], pt[0]);
        double minY = Math.min(ps[1], pt[1]);
        double maxX = Math.max(ps[0], pt[0]);
        double maxY = Math.max(ps[1], pt[1]);
        return minX <= pointGU.x && pointGU.x <= maxX && minY <= pointGU.y && pointGU.y <= maxY;
    }

    private double[] getCoords(Node n) {
        Object ap = ((AbstractGraphManager)this.viewManager.graphManager).getParticle((Node)n);
        return new double[]{((AbstractParticle)((Object)ap)).x, ((AbstractParticle)((Object)ap)).y};
    }

    private boolean edgeSelected(Edge e, Point3 p) {
        double[] pt;
        double[] ps = this.getCoords(e.getSourceNode());
        double dist = this.pDistance(p.x, p.y, ps[0], ps[1], (pt = this.getCoords(e.getTargetNode()))[0], pt[1]);
        return Math.abs(dist) < 0.005;
    }

    private double pDistance(double x, double y, double x1, double y1, double x2, double y2) {
        double yy;
        double xx;
        double A = x - x1;
        double B = y - y1;
        double C = x2 - x1;
        double D = y2 - y1;
        double dot = A * C + B * D;
        double len_sq = C * C + D * D;
        double param = -1.0;
        if (len_sq != 0.0) {
            param = dot / len_sq;
        }
        if (param < 0.0) {
            xx = x1;
            yy = y1;
        } else if (param > 1.0) {
            xx = x2;
            yy = y2;
        } else {
            xx = x1 + param * C;
            yy = y1 + param * D;
        }
        double dx = x - xx;
        double dy = y - yy;
        return Math.sqrt(dx * dx + dy * dy);
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        if (this.curElement != null) {
            this.elementMoving(this.curElement, event);
        } else {
            if (this.lastMouseDragEvent != null) {
                this.dragGraphMouseMoved(event, this.lastMouseDragEvent, (DefaultCamera2D)this.view.getCamera());
            }
            this.lastMouseDragEvent = event;
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        this.lastMouseDragEvent = null;
        if (this.curElement != null) {
            this.mouseButtonReleaseOffElement(this.curElement, event);
            this.curElement = null;
        }
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mouseMoved(MouseEvent event) {
    }

    public void dragGraphMouseMoved(MouseEvent me, MouseEvent lastMe, DefaultCamera2D camera) {
        Point3 centerGU = camera.getViewCenter();
        Point3 centerPX = camera.transformGuToPxSwing(centerGU.x, centerGU.y, 0.0);
        Point3 newCenterGU = camera.transformPxToGuSwing(centerPX.x - (double)(me.getX() - lastMe.getX()), centerPX.y - (double)(me.getY() - lastMe.getY()));
        camera.setViewCenter(newCenterGU.x, newCenterGU.y, newCenterGU.z);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mwe) {
        MouseManager.zoomGraphMouseWheelMoved(mwe, this.view.getCamera());
    }

    public static void zoomGraphMouseWheelMoved(MouseWheelEvent mwe, Camera camera) {
        double currentViewPercent;
        if (mwe.getWheelRotation() > 0) {
            double newViewPercent = camera.getViewPercent() + 0.05;
            camera.setViewPercent(newViewPercent);
        } else if (mwe.getWheelRotation() < 0 && (currentViewPercent = camera.getViewPercent()) > 0.05) {
            camera.setViewPercent(currentViewPercent - 0.05);
        }
    }
}

