/*
 * Decompiled with CFR 0.152.
 */
package network.aika.debugger;

import network.aika.debugger.activations.VisitorManager;

public class StepManager {
    boolean stopAfterProcessed;
    EventType mode = EventType.ACT;
    Long lastTimestamp = null;
    protected boolean clicked;
    private VisitorManager visitorManager;

    public StepManager(VisitorManager visitorManager) {
        this.visitorManager = visitorManager;
    }

    public void setStopAfterProcessed(boolean b) {
        this.stopAfterProcessed = b;
    }

    public void setMode(EventType mode) {
        this.mode = mode;
    }

    public synchronized void click() {
        this.clicked = true;
        this.notifyAll();
    }

    public boolean stopHere(When w, EventType et) {
        if (this.mode == null) {
            long diff = this.lastTimestamp != null ? System.currentTimeMillis() - this.lastTimestamp : 0L;
            this.lastTimestamp = System.currentTimeMillis();
            if (diff > 1000L) {
                this.setMode(EventType.VISITOR);
            } else {
                return false;
            }
        }
        if (w == When.AFTER && this.stopAfterProcessed) {
            this.stopAfterProcessed = false;
            return true;
        }
        if (this.mode == EventType.ACT && et == EventType.ACT) {
            return true;
        }
        if (this.mode == EventType.LINK && (et == EventType.ACT || et == EventType.LINK)) {
            return true;
        }
        return this.mode == EventType.VISITOR && (et == EventType.ACT || et == EventType.LINK || et == EventType.VISITOR);
    }

    public synchronized void waitForClick() {
        try {
            while (!this.clicked) {
                this.wait();
            }
            this.clicked = false;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static enum EventType {
        ACT,
        LINK,
        VISITOR;

    }

    public static enum When {
        NEW,
        BEFORE,
        AFTER;

    }
}

