/*
 * Decompiled with CFR 0.152.
 */
package network.aika.debugger.activations;

import javax.swing.text.StyledDocument;
import network.aika.debugger.AbstractConsole;
import network.aika.debugger.activations.ActivationParticle;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.activation.Element;
import network.aika.neuron.activation.Link;
import network.aika.neuron.activation.Visitor;
import network.aika.neuron.sign.Sign;
import network.aika.utils.Utils;

public class ActivationConsole
extends AbstractConsole {
    public void renderActivationConsoleOutput(StyledDocument sDoc, Activation act, ActivationParticle ap) {
        this.appendText(sDoc, "Activation \n\n", "headline");
        this.appendEntry(sDoc, "Id: ", "" + act.getId());
        this.appendEntry(sDoc, "Label: ", act.getLabel());
        this.appendEntry(sDoc, "Round(ACT): ", this.getRoundStr(act.getRound(Element.RoundType.ACT)));
        this.appendEntry(sDoc, "Round(GRADIENT): ", this.getRoundStr(act.getRound(Element.RoundType.GRADIENT)));
        this.appendEntry(sDoc, "Round(WEIGHT): ", this.getRoundStr(act.getRound(Element.RoundType.WEIGHT)));
        this.appendEntry(sDoc, "Value: ", (String)(act.getValue() != null ? "" + Utils.round((double)act.getValue()) : "X"));
        this.appendEntry(sDoc, "net[initial]: ", "" + Utils.round((double)act.getNet(false)));
        this.appendEntry(sDoc, "net[final]: ", "" + Utils.round((double)act.getNet(true)));
        this.appendEntry(sDoc, "f(net)': ", "" + Utils.round((double)act.getNeuron().getActivationFunction().outerGrad(act.getNet(true))));
        this.appendEntry(sDoc, "Input-Gradient: ", "" + Utils.round((double)act.getInputGradient()));
        this.appendEntry(sDoc, "Output-Gradient-Sum: ", "" + Utils.round((double)act.getOutputGradientSum()));
        this.appendEntry(sDoc, "Branch-Probability: ", "" + Utils.round((double)act.getBranchProbability()));
        this.appendEntry(sDoc, "Fired: ", "" + act.getFired());
        if (!act.getNeuron().isTemplate()) {
            this.appendEntry(sDoc, "Norm: ", "" + Utils.round((double)act.getNorm()));
        }
        this.appendEntry(sDoc, "Reference: ", "" + act.getReference());
        this.appendText(sDoc, "\n\n\n", "regular");
        this.renderNeuronConsoleOutput(sDoc, act.getNeuron(), act.getReference());
    }

    public void renderLinkConsoleOutput(StyledDocument sDoc, Link l) {
        this.appendText(sDoc, "Link\n\n", "headline");
        Activation oAct = l.getOutput();
        this.appendEntry(sDoc, "Input: ", l.getInput().toShortString());
        this.appendEntry(sDoc, "Input-Value: ", "" + Utils.round((double)l.getInputValue((Sign)Sign.POS)));
        this.appendEntry(sDoc, "Output: ", l.getOutput().toShortString());
        this.appendEntry(sDoc, "Output-Value: ", (String)(oAct.getValue() != null ? "" + Utils.round((double)oAct.getValue()) : "X"));
        this.appendEntry(sDoc, "Output-net[initial]: ", "" + Utils.round((double)oAct.getNet(false)));
        this.appendEntry(sDoc, "Output-net[final]: ", "" + Utils.round((double)oAct.getNet(true)));
        this.appendEntry(sDoc, "Round(ACT): ", this.getRoundStr(l.getRound(Element.RoundType.ACT)));
        this.appendEntry(sDoc, "Round(GRADIENT): ", this.getRoundStr(l.getRound(Element.RoundType.GRADIENT)));
        this.appendEntry(sDoc, "Round(WEIGHT): ", this.getRoundStr(l.getRound(Element.RoundType.WEIGHT)));
        this.appendEntry(sDoc, "IsSelfRef: ", "" + l.isSelfRef());
        this.appendEntry(sDoc, "Gradient: ", "" + Utils.round((double)l.getGradient()));
        this.appendEntry(sDoc, "f(net)': ", "" + Utils.round((double)oAct.getNeuron().getActivationFunction().outerGrad(oAct.getNet(true))));
        this.appendText(sDoc, "\n\n\n", "regular");
        this.renderSynapseConsoleOutput(sDoc, l.getSynapse(), l.getInput().getReference());
    }

    public void renderVisitorConsoleOutput(StyledDocument sDoc, Visitor v, boolean dir) {
        this.appendText(sDoc, "Visitor " + (dir ? "(up)" : "(down)") + "\n\n", "headline");
        this.appendText(sDoc, "\n", "regular");
        this.appendEntry(sDoc, "Origin:", v.origin.act.toShortString());
        this.appendText(sDoc, "\n", "regular");
        do {
            this.renderVisitorStep(sDoc, v);
            this.appendText(sDoc, "\n", "regular");
        } while ((v = v.previousStep) != null);
    }

    public void renderVisitorStep(StyledDocument sDoc, Visitor v) {
        this.appendText(sDoc, v.transition.name() + "\n", "bold");
        if (v.act != null) {
            this.appendEntry(sDoc, "Current:", v.act.toShortString());
        } else if (v.link != null) {
            this.appendEntry(sDoc, "Current:", v.link.toString());
        }
        this.appendEntry(sDoc, "DownUp:", "" + v.downUpDir);
        this.appendEntry(sDoc, "StartDir:", "" + v.startDir);
        this.appendEntry(sDoc, "Scopes:", v.getScopes().toString());
        this.appendEntry(sDoc, "DownSteps:", "" + v.downSteps);
        this.appendEntry(sDoc, "UpSteps:", "" + v.upSteps);
    }
}

