/*
 * Decompiled with CFR 0.152.
 */
package network.aika.debugger.activations;

import network.aika.debugger.AbstractLayout;
import network.aika.debugger.activations.ActivationGraphManager;
import network.aika.debugger.activations.ActivationParticle;
import network.aika.debugger.activations.ActivationViewManager;
import network.aika.neuron.activation.Activation;
import network.aika.text.Document;
import org.graphstream.graph.Node;
import org.graphstream.ui.layout.springbox.NodeParticle;
import org.miv.pherd.geom.Point3;

public class ActivationLayout
extends AbstractLayout<ActivationGraphManager> {
    ActivationViewManager avm;

    public ActivationLayout(ActivationViewManager avm, ActivationGraphManager gm) {
        super(gm);
        this.avm = avm;
        k = STANDARD_DISTANCE_X;
        K1Init = 0.06f;
        K1Final = 0.01f;
        this.K2 = 0.005f;
    }

    public NodeParticle newNodeParticle(String id) {
        Double y;
        Double x;
        Document doc = this.avm.getDocument();
        Node n = ((ActivationGraphManager)this.graphManager).getNode(id);
        Activation act = doc.getActivation((Integer)n.getAttribute("aika.id", Integer.class));
        Integer originActId = (Integer)n.getAttribute("aika.originActId", Integer.class);
        if (originActId != null) {
            ActivationParticle originParticle = (ActivationParticle)((Object)((ActivationGraphManager)this.graphManager).getParticle(originActId.intValue()));
            Point3 originPos = originParticle.getPosition();
            x = originPos.x;
            y = originPos.y + STANDARD_DISTANCE_Y;
        } else {
            x = (Double)n.getAttribute("x");
            y = (Double)n.getAttribute("y");
            if (x == null) {
                x = 0.0;
            }
            if (y == null) {
                y = 0.0;
            }
        }
        if (Math.abs(x) < 0.01 || Math.abs(y) < 0.01) {
            x = x + (this.random.nextDouble() - 0.5) * 0.02;
            y = y + (this.random.nextDouble() - 0.5) * 0.02;
        }
        ActivationParticle particle = new ActivationParticle(this, n, act, id, x, y, 0.0);
        ((ActivationGraphManager)this.graphManager).setParticle(act, particle);
        return particle;
    }
}

