/*
 * Decompiled with CFR 0.152.
 */
package network.aika.debugger.activations;

import network.aika.debugger.AbstractLayout;
import network.aika.debugger.AbstractParticle;
import network.aika.neuron.Synapse;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.activation.Link;
import network.aika.neuron.excitatory.PatternPartSynapse;
import network.aika.neuron.inhibitory.InhibitoryNeuron;
import org.graphstream.graph.Node;
import org.graphstream.ui.geom.Vector2;
import org.graphstream.ui.geom.Vector3;
import org.graphstream.ui.layout.springbox.EdgeSpring;
import org.graphstream.ui.layout.springbox.Energies;
import org.graphstream.ui.layout.springbox.NodeParticle;
import org.graphstream.ui.layout.springbox.implementations.SpringBox;
import org.miv.pherd.geom.Point3;

public class ActivationParticle
extends AbstractParticle {
    public static double K1 = 0.12f;
    public static double K2 = 0.03f;
    Activation act;
    Node node;

    public ActivationParticle(AbstractLayout layout, Node node, Activation act, String id, double x, double y, double z) {
        super(layout, id, x, y, z);
        this.act = act;
        this.node = node;
    }

    protected void attraction(Vector3 delta) {
        SpringBox box = (SpringBox)this.box;
        Energies energies = box.getEnergies();
        for (EdgeSpring edge : this.neighbours) {
            PatternPartSynapse pps;
            boolean isRecurrent;
            Synapse s;
            if (edge.ignored) continue;
            ActivationParticle other = (ActivationParticle)edge.getOpposite((NodeParticle)this);
            Point3 opos = other.getPosition();
            Link link = this.getLink(other.act, this.act);
            if (link != null && (s = link.getSynapse()) instanceof PatternPartSynapse && ((isRecurrent = (pps = (PatternPartSynapse)s).isRecurrent() && !s.getOutput().isInputNeuron()) || link.getOutput().getNeuron().isInputNeuron() && link.getInput().getNeuron() instanceof InhibitoryNeuron || pps.isSamePattern()) || link == null) continue;
            double dy = 0.0;
            if (this.act == link.getOutput()) {
                dy = opos.y + AbstractLayout.STANDARD_DISTANCE_Y - this.pos.y;
                dy = Math.max(0.0, dy);
            } else {
                dy = opos.y - (this.pos.y + AbstractLayout.STANDARD_DISTANCE_Y);
                dy = Math.min(0.0, dy);
            }
            delta.set(0.0, dy, 0.0);
            delta.mult(new Vector2(0.0, K1));
            this.disp.add(delta);
            this.attE += K1;
            energies.accumulateEnergy(K1);
        }
    }

    private Link getLink(Activation actA, Activation actB) {
        Link l = this.getDirectedLink(actA, actB);
        if (l != null) {
            return l;
        }
        return this.getDirectedLink(actB, actA);
    }

    private Link getDirectedLink(Activation iAct, Activation oAct) {
        return oAct.getInputLinks().filter(l -> l.getInput() == iAct).findFirst().orElse(null);
    }
}

