/*
 * Decompiled with CFR 0.152.
 */
package network.aika.debugger.activations;

import java.awt.Dimension;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.StyledDocument;
import network.aika.callbacks.EventListener;
import network.aika.debugger.AbstractLayout;
import network.aika.debugger.AbstractViewManager;
import network.aika.debugger.StepManager;
import network.aika.debugger.activations.ActivationConsole;
import network.aika.debugger.activations.ActivationGraphManager;
import network.aika.debugger.activations.ActivationLayout;
import network.aika.debugger.activations.ActivationParticle;
import network.aika.debugger.activations.QueueConsole;
import network.aika.debugger.activations.VisitorManager;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.activation.Fired;
import network.aika.neuron.activation.Link;
import network.aika.neuron.activation.QueueEntry;
import network.aika.neuron.excitatory.PatternNeuron;
import network.aika.neuron.phase.Phase;
import network.aika.text.Document;
import network.aika.text.TextModel;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Element;
import org.graphstream.graph.Node;
import org.graphstream.ui.geom.Point3;
import org.graphstream.ui.graphicGraph.GraphicElement;
import org.graphstream.ui.layout.Layout;
import org.graphstream.ui.view.camera.DefaultCamera2D;

public class ActivationViewManager
extends AbstractViewManager<ActivationConsole, ActivationGraphManager>
implements EventListener {
    private Document doc;
    private VisitorManager visitorManager;
    private QueueConsole queueConsole;
    protected StepManager stepManager;
    private Long numberOfInputTokens;

    public ActivationViewManager(Document doc) {
        this.computeNumberOfInputTokens(doc);
        double width = (double)this.numberOfInputTokens.longValue() * AbstractLayout.STANDARD_DISTANCE_X;
        double height = 3.0 * AbstractLayout.STANDARD_DISTANCE_Y;
        this.getCamera().setGraphViewport(-(width / 2.0), -(height / 2.0), width / 2.0, height / 2.0);
        this.getCamera().setViewCenter(0.2, 0.2, 0.0);
        this.graphManager = new ActivationGraphManager(this.graph);
        this.doc = doc;
        doc.addEventListener((EventListener)this);
        this.visitorManager = new VisitorManager(this);
        this.console = new ActivationConsole();
        this.queueConsole = new QueueConsole();
        this.viewer.enableAutoLayout((Layout)new ActivationLayout(this, (ActivationGraphManager)this.graphManager));
        this.splitPane = this.initSplitPane();
        this.stepManager = new StepManager(this.visitorManager);
    }

    public double scaleCharsToTokens() {
        return (double)this.numberOfInputTokens.longValue() / (double)this.doc.length();
    }

    public StepManager getStepManager() {
        return this.stepManager;
    }

    public void pumpAndWaitForUserAction() {
        this.pump();
        this.stepManager.waitForClick();
    }

    @Override
    public void showElementContext(String headlinePrefix, GraphicElement ge) {
        if (ge instanceof Node) {
            Node n = (Node)ge;
            Activation act = (Activation)((ActivationGraphManager)this.graphManager).getAikaNode(n);
            if (act == null) {
                return;
            }
            ((ActivationConsole)this.console).render(headlinePrefix, sDoc -> ((ActivationConsole)this.console).renderActivationConsoleOutput((StyledDocument)sDoc, act, (ActivationParticle)((Object)((Object)((ActivationGraphManager)this.graphManager).getParticle(act)))));
        } else if (ge instanceof Edge) {
            Edge e = (Edge)ge;
            Link l = ((ActivationGraphManager)this.graphManager).getLink(e);
            if (l == null) {
                return;
            }
            ((ActivationConsole)this.console).render(headlinePrefix, sDoc -> ((ActivationConsole)this.console).renderLinkConsoleOutput((StyledDocument)sDoc, l));
        }
    }

    @Override
    public JComponent getConsolePane() {
        JScrollPane paneScrollPane = new JScrollPane(this.console);
        paneScrollPane.setVerticalScrollBarPolicy(22);
        paneScrollPane.setPreferredSize(new Dimension(250, 155));
        paneScrollPane.setMinimumSize(new Dimension(10, 10));
        JScrollPane queuePaneScrollPane = new JScrollPane(this.queueConsole);
        queuePaneScrollPane.setVerticalScrollBarPolicy(22);
        queuePaneScrollPane.setPreferredSize(new Dimension(250, 155));
        queuePaneScrollPane.setMinimumSize(new Dimension(10, 10));
        JSplitPane sp = new JSplitPane(0, paneScrollPane, queuePaneScrollPane);
        sp.setResizeWeight(0.52);
        return sp;
    }

    public void onActivationCreationEvent(Activation act, Activation originAct) {
        Node n = this.onActivationEvent(act, originAct);
        if (!this.stepManager.stopHere(StepManager.When.NEW, StepManager.EventType.ACT)) {
            return;
        }
        n.setAttribute("aika.init-node", new Object[]{true});
        ((ActivationConsole)this.console).render("New", sDoc -> ((ActivationConsole)this.console).renderActivationConsoleOutput((StyledDocument)sDoc, act, (ActivationParticle)((Object)((Object)((ActivationGraphManager)this.graphManager).getParticle(act)))));
        this.pumpAndWaitForUserAction();
    }

    public void beforeProcessedEvent(QueueEntry qe) {
        if (qe.getElement() instanceof Activation) {
            this.beforeActivationProcessedEvent(qe, (Activation)qe.getElement());
        } else if (qe.getElement() instanceof Link) {
            this.beforeLinkProcessedEvent(qe, (Link)qe.getElement());
        }
    }

    public void afterProcessedEvent(QueueEntry qe) {
        if (qe.getElement() instanceof Activation) {
            this.afterActivationProcessedEvent(qe, (Activation)qe.getElement());
        } else if (qe.getElement() instanceof Link) {
            this.afterLinkProcessedEvent(qe, (Link)qe.getElement());
        }
    }

    private void beforeActivationProcessedEvent(QueueEntry qe, Activation act) {
        this.queueConsole.render("Queue", sDoc -> this.queueConsole.renderQueue((StyledDocument)sDoc, act.getThought(), qe));
        Node n = this.onActivationEvent(act, null);
        n.setAttribute("aika.init-node", new Object[]{false});
        if (!this.stepManager.stopHere(StepManager.When.BEFORE, StepManager.EventType.ACT)) {
            return;
        }
        ((ActivationConsole)this.console).render("Before " + Phase.toString((Phase)qe.getPhase()), sDoc -> ((ActivationConsole)this.console).renderActivationConsoleOutput((StyledDocument)sDoc, act, (ActivationParticle)((Object)((Object)((ActivationGraphManager)this.graphManager).getParticle(act)))));
        this.pumpAndWaitForUserAction();
    }

    private void afterActivationProcessedEvent(QueueEntry qe, Activation act) {
        this.queueConsole.render("Queue", sDoc -> this.queueConsole.renderQueue((StyledDocument)sDoc, act.getThought(), qe));
        if (!this.stepManager.stopHere(StepManager.When.AFTER, StepManager.EventType.ACT)) {
            return;
        }
        ((ActivationConsole)this.console).render("After " + Phase.toString((Phase)qe.getPhase()), sDoc -> ((ActivationConsole)this.console).renderActivationConsoleOutput((StyledDocument)sDoc, act, (ActivationParticle)((Object)((Object)((ActivationGraphManager)this.graphManager).getParticle(act)))));
        this.pumpAndWaitForUserAction();
    }

    private void computeNumberOfInputTokens(Document doc) {
        this.numberOfInputTokens = doc.getActivations().stream().filter(act -> act.getNeuron().isInputNeuron() && act.getNeuron() instanceof PatternNeuron).count();
    }

    private Node onActivationEvent(Activation act, Activation originAct) {
        Node node = ((ActivationGraphManager)this.graphManager).lookupNode(act, n -> {
            if (originAct != null) {
                Edge initialEdge = ((ActivationGraphManager)this.graphManager).lookupEdge(originAct, act, e -> {});
                initialEdge.setAttribute("ui.style", new Object[]{"fill-color: rgb(200,200,200);"});
            }
            if (act.getNeuron().isInputNeuron() && act.getNeuron() instanceof PatternNeuron) {
                n.setAttribute("layout.frozen", new Object[0]);
            }
            if (act.getNeuron().isInputNeuron() && act.getFired() != Fired.NOT_FIRED) {
                Fired f = act.getFired();
                n.setAttribute("x", new Object[]{this.getXPosGU(f)});
            }
            if (act.getNeuron().isInputNeuron() && originAct != null && originAct.getFired() != Fired.NOT_FIRED) {
                double offset = AbstractLayout.STANDARD_DISTANCE_X * 0.3;
                Fired f = originAct.getFired();
                if (act.getLabel().endsWith(TextModel.REL_NEXT_TOKEN_LABEL)) {
                    n.setAttribute("x", new Object[]{this.getXPosGU(f) + offset});
                }
                if (act.getLabel().endsWith(TextModel.REL_PREVIOUS_TOKEN_LABEL)) {
                    n.setAttribute("x", new Object[]{this.getXPosGU(f) - offset});
                }
            }
        });
        node.setAttribute("aika.id", new Object[]{act.getId()});
        if (originAct != null) {
            node.setAttribute("aika.originActId", new Object[]{originAct.getId()});
        }
        node.setAttribute("ui.label", new Object[]{act.getLabel()});
        this.highlightCurrentOnly((Element)node);
        Consumer neuronTypeModifier = (Consumer)this.neuronTypeModifiers.get(act.getNeuron().getClass());
        if (neuronTypeModifier != null) {
            neuronTypeModifier.accept(node);
        }
        return node;
    }

    private double getXPosGU(Fired f) {
        return (double)f.getInputTimestamp() * this.scaleCharsToTokens() * AbstractLayout.STANDARD_DISTANCE_X;
    }

    private void highlightCurrentOnly(Element e) {
        if (this.lastHighlighted != e) {
            if (this.lastHighlighted != null) {
                this.unhighlightElement(this.lastHighlighted);
            }
            this.lastHighlighted = e;
            this.highlightElement(e);
        }
    }

    public void onLinkCreationEvent(Link l) {
        Edge e = this.onLinkEvent(l);
        e.setAttribute("aika.init-node", new Object[]{true});
        if (!this.stepManager.stopHere(StepManager.When.NEW, StepManager.EventType.LINK)) {
            return;
        }
        ((ActivationConsole)this.console).render("New", sDoc -> ((ActivationConsole)this.console).renderLinkConsoleOutput((StyledDocument)sDoc, l));
        this.pumpAndWaitForUserAction();
    }

    private void beforeLinkProcessedEvent(QueueEntry qe, Link l) {
        this.queueConsole.render("Queue", sDoc -> this.queueConsole.renderQueue((StyledDocument)sDoc, l.getThought(), qe));
        Edge e = this.onLinkEvent(l);
        e.setAttribute("aika.init-node", new Object[]{false});
        if (!this.stepManager.stopHere(StepManager.When.BEFORE, StepManager.EventType.LINK)) {
            return;
        }
        DefaultStyledDocument sDoc2 = new DefaultStyledDocument();
        ((ActivationConsole)this.console).addStylesToDocument(sDoc2);
        ((ActivationConsole)this.console).clear();
        ((ActivationConsole)this.console).addHeadline(sDoc2, "Before " + Phase.toString((Phase)qe.getPhase()));
        ((ActivationConsole)this.console).renderLinkConsoleOutput(sDoc2, l);
        ((ActivationConsole)this.console).setStyledDocument(sDoc2);
        this.pumpAndWaitForUserAction();
    }

    private void afterLinkProcessedEvent(QueueEntry qe, Link l) {
        this.queueConsole.render("Queue", sDoc -> this.queueConsole.renderQueue((StyledDocument)sDoc, l.getThought(), qe));
        if (!this.stepManager.stopHere(StepManager.When.AFTER, StepManager.EventType.LINK)) {
            return;
        }
        DefaultStyledDocument sDoc2 = new DefaultStyledDocument();
        ((ActivationConsole)this.console).addStylesToDocument(sDoc2);
        ((ActivationConsole)this.console).clear();
        ((ActivationConsole)this.console).addHeadline(sDoc2, "After " + Phase.toString((Phase)qe.getPhase()));
        ((ActivationConsole)this.console).renderLinkConsoleOutput(sDoc2, l);
        ((ActivationConsole)this.console).setStyledDocument(sDoc2);
        this.pumpAndWaitForUserAction();
    }

    private Edge onLinkEvent(Link l) {
        Edge edge = ((ActivationGraphManager)this.graphManager).lookupEdge(l, e -> {});
        this.highlightCurrentOnly((Element)edge);
        BiConsumer synapseTypeModifier = (BiConsumer)this.synapseTypeModifiers.get(l.getSynapse().getClass());
        if (synapseTypeModifier != null) {
            synapseTypeModifier.accept(edge, l.getSynapse());
        }
        return edge;
    }

    @Override
    public void viewClosed(String id) {
    }

    @Override
    public void click(int x, int y) {
        DefaultCamera2D camera = (DefaultCamera2D)this.getCamera();
        Point3 guPoint = camera.transformPxToGuSwing((double)x, (double)y);
    }

    public Document getDocument() {
        return this.doc;
    }

    public VisitorManager getVisitorManager() {
        return this.visitorManager;
    }
}

