/*
 * Decompiled with CFR 0.152.
 */
package network.aika.debugger.activations;

import javax.swing.text.StyledDocument;
import network.aika.Thought;
import network.aika.debugger.AbstractConsole;
import network.aika.neuron.activation.QueueEntry;

public class QueueConsole
extends AbstractConsole {
    public void renderQueue(StyledDocument sDoc, Thought t, QueueEntry currentQE) {
        this.renderQueueEntry(sDoc, currentQE, currentQE.getCurrentTimestamp());
        this.appendText(sDoc, "------------------------------------------------------------------------------------------------------------------------------\n", "regular");
        for (QueueEntry qe : t.getQueue()) {
            this.renderQueueEntry(sDoc, qe, currentQE.getCurrentTimestamp());
        }
        this.appendText(sDoc, "\n\n\n", "regular");
    }

    public void renderQueueEntry(StyledDocument sDoc, QueueEntry qe, long currentTimestamp) {
        boolean isGreen = currentTimestamp == qe.getAddedTimestamp();
        this.appendEntry(sDoc, qe.getAddedTimestamp() + " " + this.getRoundStr(qe.getRound()) + " " + qe.getPhase() + " ", qe.getElement().toShortString(), isGreen ? "boldGreen" : "bold", isGreen ? "regularGreen" : "regular");
    }
}

