/*
 * Decompiled with CFR 0.152.
 */
package network.aika.debugger.activations;

import javax.swing.text.StyledDocument;
import network.aika.callbacks.VisitorEventListener;
import network.aika.debugger.StepManager;
import network.aika.debugger.activations.ActivationConsole;
import network.aika.debugger.activations.ActivationGraphManager;
import network.aika.debugger.activations.ActivationViewManager;
import network.aika.neuron.activation.Visitor;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Element;
import org.graphstream.graph.Node;

public class VisitorManager
implements VisitorEventListener {
    private ActivationViewManager avm;

    public VisitorManager(ActivationViewManager avm) {
        this.avm = avm;
        avm.getDocument().addVisitorEventListener((VisitorEventListener)this);
    }

    public void onVisitorEvent(Visitor v, boolean dir) {
        if (!this.avm.stepManager.stopHere(StepManager.When.BEFORE, StepManager.EventType.VISITOR)) {
            return;
        }
        ((ActivationConsole)this.avm.getConsole()).render("Visitor", sDoc -> ((ActivationConsole)this.avm.getConsole()).renderVisitorConsoleOutput((StyledDocument)sDoc, v, dir));
        ActivationGraphManager gm = (ActivationGraphManager)this.avm.getGraphManager();
        switch (v.transition) {
            case ACT: {
                Node n = gm.getNode(v.act);
                if (n == null) break;
                if (!dir) {
                    this.avm.highlightElement((Element)n);
                    break;
                }
                this.avm.unhighlightElement((Element)n);
                break;
            }
            case LINK: {
                Edge e = gm.getEdge(v.link);
                if (e == null) break;
                if (!dir) {
                    this.avm.highlightElement((Element)e);
                    break;
                }
                this.avm.unhighlightElement((Element)e);
            }
        }
        this.avm.pump();
        this.avm.stepManager.waitForClick();
    }
}

