/*
 * Decompiled with CFR 0.152.
 */
package network.aika.debugger.neurons;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import network.aika.Model;
import network.aika.debugger.AbstractLayout;
import network.aika.debugger.AbstractViewManager;
import network.aika.debugger.neurons.NeuronConsole;
import network.aika.debugger.neurons.NeuronGraphManager;
import network.aika.neuron.Neuron;
import network.aika.neuron.Synapse;
import org.graphstream.graph.Edge;

public abstract class AbstractNeuronViewManager
extends AbstractViewManager<NeuronConsole, NeuronGraphManager> {
    private Model model;

    public AbstractNeuronViewManager(Model model) {
        this.model = model;
    }

    public Model getModel() {
        return this.model;
    }

    public abstract void initGraphNeurons();

    protected void drawNeuron(Neuron<?> n, double x, double y) {
        ((NeuronGraphManager)this.graphManager).lookupNode(n, node -> {
            node.setAttribute("aika.neuronId", new Object[]{n.getId()});
            Consumer neuronTypeModifier = (Consumer)this.neuronTypeModifiers.get(n.getClass());
            if (neuronTypeModifier != null) {
                neuronTypeModifier.accept(node);
            }
            node.setAttribute("x", new Object[]{x});
            node.setAttribute("y", new Object[]{y});
            n.getInputSynapses().forEach(s -> this.drawSynapse((Synapse)s));
            n.getOutputSynapses().forEach(s -> {
                if (!s.isRecurrent() || s.getOutput().isInputNeuron()) {
                    this.drawNeuron(s.getOutput(), x, y + AbstractLayout.STANDARD_DISTANCE_Y);
                }
                this.drawSynapse((Synapse)s);
            });
        });
    }

    protected void drawSynapse(Synapse s) {
        if (((NeuronGraphManager)this.graphManager).getNode(s.getInput()) == null || ((NeuronGraphManager)this.graphManager).getNode(s.getOutput()) == null) {
            return;
        }
        Edge edge = ((NeuronGraphManager)this.graphManager).lookupEdge(s, e -> {});
        BiConsumer synapseTypeModifier = (BiConsumer)this.synapseTypeModifiers.get(s.getClass());
        if (synapseTypeModifier != null) {
            synapseTypeModifier.accept(edge, s);
        }
    }
}

