/*
 * Decompiled with CFR 0.152.
 */
package network.aika.debugger.neurons;

import javax.swing.JComponent;
import javax.swing.text.StyledDocument;
import network.aika.Model;
import network.aika.debugger.AbstractLayout;
import network.aika.debugger.neurons.AbstractNeuronViewManager;
import network.aika.debugger.neurons.NeuronConsole;
import network.aika.debugger.neurons.NeuronGraphManager;
import network.aika.debugger.neurons.NeuronLayout;
import network.aika.neuron.Neuron;
import network.aika.neuron.activation.Activation;
import network.aika.text.Document;
import org.graphstream.graph.Node;
import org.graphstream.ui.graphicGraph.GraphicElement;
import org.graphstream.ui.layout.Layout;

public class NeuronViewManager
extends AbstractNeuronViewManager {
    private Document document;

    public NeuronViewManager(Model m, Document document) {
        super(m);
        this.graphManager = new NeuronGraphManager(this.graph);
        this.document = document;
        this.console = new NeuronConsole();
        this.viewer.enableAutoLayout((Layout)new NeuronLayout(this, (NeuronGraphManager)this.graphManager));
        this.splitPane = this.initSplitPane();
    }

    @Override
    public void showElementContext(String headlinePrefix, GraphicElement ge) {
        if (ge instanceof Node) {
            Node n = (Node)ge;
            Neuron neuron = (Neuron)((NeuronGraphManager)this.graphManager).getAikaNode(n);
            if (neuron == null) {
                return;
            }
            ((NeuronConsole)this.console).render(headlinePrefix, sDoc -> ((NeuronConsole)this.console).renderNeuronConsoleOutput((StyledDocument)sDoc, neuron, null));
        }
    }

    @Override
    public JComponent getConsolePane() {
        return this.console;
    }

    @Override
    public void viewClosed(String id) {
    }

    @Override
    public void click(int x, int y) {
    }

    @Override
    public void initGraphNeurons() {
        double[] x = new double[]{0.0};
        this.document.getActivations().stream().map(Activation::getNeuron).filter(n -> n.isInputNeuron()).forEach(n -> {
            this.drawNeuron((Neuron<?>)n, x[0], 0.0);
            x[0] = x[0] + AbstractLayout.STANDARD_DISTANCE_X;
        });
    }
}

