/*
 * Decompiled with CFR 0.152.
 */
package network.aika.debugger.neurons.templates;

import javax.swing.JComponent;
import javax.swing.text.StyledDocument;
import network.aika.Model;
import network.aika.debugger.neurons.AbstractNeuronViewManager;
import network.aika.debugger.neurons.NeuronConsole;
import network.aika.debugger.neurons.NeuronGraphManager;
import network.aika.debugger.neurons.NeuronLayout;
import network.aika.neuron.Neuron;
import org.graphstream.graph.Node;
import org.graphstream.ui.graphicGraph.GraphicElement;
import org.graphstream.ui.layout.Layout;

public class TemplateViewManager
extends AbstractNeuronViewManager {
    public TemplateViewManager(Model m) {
        super(m);
        this.graphManager = new NeuronGraphManager(this.graph);
        this.console = new NeuronConsole();
        this.viewer.enableAutoLayout((Layout)new NeuronLayout(this, (NeuronGraphManager)this.graphManager));
        this.splitPane = this.initSplitPane();
    }

    @Override
    public void showElementContext(String headlinePrefix, GraphicElement ge) {
        if (ge instanceof Node) {
            Node n = (Node)ge;
            Neuron neuron = (Neuron)((NeuronGraphManager)this.graphManager).getAikaNode(n);
            if (neuron == null) {
                return;
            }
            ((NeuronConsole)this.console).render(headlinePrefix, sDoc -> ((NeuronConsole)this.console).renderNeuronConsoleOutput((StyledDocument)sDoc, neuron, null));
        }
    }

    @Override
    public JComponent getConsolePane() {
        return this.console;
    }

    @Override
    public void viewClosed(String id) {
    }

    @Override
    public void click(int x, int y) {
    }

    @Override
    public void initGraphNeurons() {
        this.getModel().getTemplates().getAllTemplates().forEach(n -> this.drawNeuron((Neuron<?>)n, 0.0, 0.0));
    }
}

