/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package network.aika.debugger.activations;

import network.aika.debugger.AbstractConsole;
import network.aika.neuron.activation.Element;
import network.aika.steps.Step;

import javax.swing.text.StyledDocument;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import static network.aika.debugger.activations.QueueConsole.renderQueueEntry;

/**
 * @author Lukas Molzberger
 */
public class ElementQueueConsole extends AbstractConsole {

    public void renderElementQueueOutput(StyledDocument sDoc, Element e, Step step, String event) {

        if(step != null)
            appendText(sDoc, event + " " + step.getTimestamp() + ":" + step.getClass().getSimpleName() + "\n", "headline");
        else
            appendText(sDoc, event + "\n", "headline");


        Stream<Step> elementQueue = e.getQueuedSteps();

        elementQueue = elementQueue.collect(
                Collectors.toCollection(() ->
                        new TreeSet<>(Step.COMPARATOR)
                )
        ).stream();

        elementQueue.forEach(s ->
                renderQueueEntry(sDoc, e.getThought(), s)
        );
    }
}
