/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package network.aika.debugger.activations;

import network.aika.Thought;
import network.aika.debugger.AbstractConsole;
import network.aika.neuron.activation.Timestamp;
import network.aika.steps.Step;

import javax.swing.text.StyledDocument;

import static network.aika.neuron.activation.Timestamp.NOT_SET;

/**
 * @author Lukas Molzberger
 */
public class QueueConsole extends AbstractConsole {

    public void renderQueue(StyledDocument sDoc, Thought<?> t, Step currentQE) {
        if(currentQE != null)
            renderQueueEntry(sDoc, t, currentQE);

        appendText(sDoc, "---------------------------------------------------------------------------------------------------------------------------------------------------------------------\n", "regular");
        for(Step s: t.getQueue()) {
            renderQueueEntry(sDoc, t, s);
        }

        appendText(sDoc, "\n\n\n", "regular");
    }

    public static void renderQueueEntry(StyledDocument sDoc, Thought<?> t, Step s) {
        Timestamp currentTimestamp = t.getTimestampOnProcess();
        String regularColor = "regular";
        String boldColor = "bold";
        if(currentTimestamp.compareTo(s.getTimestamp()) <= 0) {
            regularColor = "regularGreen";
            boldColor = "boldGreen";
        }

        appendEntry(
                sDoc,
                getQueueEntrySortKeyDescription(s),
                s.toString(),
                boldColor,
                regularColor
        );
    }

    public static String getQueueEntrySortKeyDescription(Step s) {
        return s.getPhase().name() + " " + (s.getFired() != NOT_SET ? "Fired:" + s.getFired() : "Pre-Fired") + " TS:" + s.getTimestamp() + " " + s.getStepName() + " ";
    }
}
