/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package network.aika.debugger.neurons;

import network.aika.debugger.AbstractConsoleManager;
import network.aika.neuron.Neuron;
import network.aika.neuron.Synapse;
import network.aika.neuron.activation.Activation;
import network.aika.neuron.activation.Link;

import javax.swing.*;
import java.awt.*;


/**
 * @author Lukas Molzberger
 */
public class NeuronConsoleManager extends AbstractConsoleManager<NeuronConsole> {

    private JTabbedPane neuronViewTabbedPane;

    public NeuronConsoleManager() {
        super(new NeuronConsole(), new NeuronConsole());
    }

    private JComponent initActivationViewTabbedPane() {
        neuronViewTabbedPane = new JTabbedPane();
//        ImageIcon icon = createImageIcon("images/middle.gif");

        //The following line enables to use scrolling tabs.
        neuronViewTabbedPane.setTabLayoutPolicy(JTabbedPane.SCROLL_TAB_LAYOUT);

        neuronViewTabbedPane.setFocusCycleRoot(true);

        neuronViewTabbedPane.addTab(
                "Main",
                null,
                getScrollPane(mainConsole),
                "Shows the currently processed graph element"
        );

        neuronViewTabbedPane.addTab(
                "Selected",
                null,
                getScrollPane(selectedConsole),
                "Shows the selected graph element"
        );

        return neuronViewTabbedPane;
    }

    public void showSelectedElementContext(Neuron n) {
        neuronViewTabbedPane.setSelectedIndex(1);
        selectedConsole.render(sDoc ->
                selectedConsole.renderNeuronConsoleOutput(sDoc, n, null)
        );
    }

    public void showSelectedElementContext(Synapse s) {
        neuronViewTabbedPane.setSelectedIndex(1);
        selectedConsole.render(sDoc ->
                selectedConsole.renderSynapseConsoleOutput(sDoc, s, null)
        );
    }

    private static JScrollPane getScrollPane(Component c) {
        JScrollPane scrollPane = new JScrollPane(c);
        scrollPane.setVerticalScrollBarPolicy(
                JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
        scrollPane.setPreferredSize(new Dimension(250, 155));
        scrollPane.setMinimumSize(new Dimension(10, 10));
        return scrollPane;
    }

    @Override
    public JComponent getConsolePane() {
        return initActivationViewTabbedPane();
    }
}
