/*
 * Decompiled with CFR 0.152.
 */
package network.aika.debugger;

import java.awt.Component;
import java.awt.GridLayout;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import network.aika.Model;
import network.aika.debugger.AIKADebugManager;
import network.aika.debugger.KeyManager;
import network.aika.debugger.activations.ActivationConsoleManager;
import network.aika.debugger.activations.ActivationGraphManager;
import network.aika.debugger.activations.ActivationViewManager;
import network.aika.debugger.neurons.NeuronConsoleManager;
import network.aika.debugger.neurons.NeuronViewManager;
import network.aika.debugger.neurons.templates.TemplateViewManager;
import network.aika.debugger.stepmanager.DebugStepManager;
import network.aika.debugger.stepmanager.StepManager;
import network.aika.debugger.stepmanager.StepMode;
import network.aika.text.Document;

public class AIKADebugger
extends JPanel
implements AIKADebugManager {
    private JTabbedPane tabbedPane;
    private ActivationViewManager actViewManager;
    private NeuronViewManager neuronViewManager;
    private TemplateViewManager templateViewManager;
    private KeyManager keyManager;
    public static final Integer ACTIVATION_TAB_INDEX = 0;
    public static final Integer NEURON_TAB_INDEX = 1;
    public static final Integer TEMPLATE_TAB_INDEX = 2;
    private Map<Integer, Runnable> testCaseListeners = new TreeMap<Integer, Runnable>();

    public AIKADebugger() {
        super(new GridLayout(1, 1));
        this.tabbedPane = new JTabbedPane();
        this.add(this.tabbedPane);
        this.tabbedPane.setTabLayoutPolicy(1);
        this.tabbedPane.setFocusCycleRoot(true);
        this.keyManager = new KeyManager(this);
        this.tabbedPane.addKeyListener(this.keyManager);
        this.tabbedPane.addChangeListener(event -> {
            if (this.tabbedPane.getSelectedIndex() == NEURON_TAB_INDEX.intValue()) {
                this.neuronViewManager.updateGraphNeurons();
            } else if (this.tabbedPane.getSelectedIndex() == TEMPLATE_TAB_INDEX.intValue()) {
                this.templateViewManager.updateGraphNeurons();
            }
        });
    }

    public AIKADebugger(Document doc) {
        this();
        this.setDocument(doc);
        this.setModel(doc.getModel());
    }

    private void setModel(Model model) {
        this.neuronViewManager = new NeuronViewManager(model, new NeuronConsoleManager(), (ActivationGraphManager)this.actViewManager.getGraphManager());
        this.addTab(NEURON_TAB_INDEX, "Neurons", 78, this.neuronViewManager.getView());
        this.templateViewManager = new TemplateViewManager(model, new NeuronConsoleManager());
        this.addTab(TEMPLATE_TAB_INDEX, "Templates", 78, this.templateViewManager.getView());
    }

    private void setDocument(Document doc) {
        this.actViewManager = new ActivationViewManager(doc, new ActivationConsoleManager(doc));
        this.actViewManager.setStepManager(new DebugStepManager());
        this.addTab(ACTIVATION_TAB_INDEX, "Activations", 65, this.actViewManager.getView());
        this.actViewManager.enableAutoLayout();
    }

    @Override
    public ActivationViewManager getActivationViewManager() {
        return this.actViewManager;
    }

    @Override
    public NeuronViewManager getNeuronViewManager() {
        return this.neuronViewManager;
    }

    @Override
    public TemplateViewManager getTemplateViewManager() {
        return this.templateViewManager;
    }

    public KeyManager getKeyManager() {
        return this.keyManager;
    }

    public void setStepMode(StepMode mode) {
        this.getStepManager().setMode(mode);
    }

    public StepManager getStepManager() {
        return this.actViewManager.getStepManager();
    }

    public void addTab(int tabIndex, String label, int ke, JComponent panel) {
        this.tabbedPane.addTab(label, null, panel, "Does nothing");
        this.tabbedPane.setMnemonicAt(tabIndex, ke);
    }

    public void removeTab(int tabIndex) {
        this.tabbedPane.removeTabAt(tabIndex);
    }

    public void selectTab(int tabIndex) {
        this.tabbedPane.setSelectedIndex(tabIndex);
    }

    public static AIKADebugger createAndShowGUI(Document doc) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JFrame frame = new JFrame("AIKA Debugger");
        frame.setDefaultCloseOperation(3);
        AIKADebugger d = new AIKADebugger(doc);
        frame.add((Component)d, "Center");
        frame.setVisible(true);
        frame.setExtendedState(frame.getExtendedState() | 6);
        return d;
    }
}

