/*
 * Decompiled with CFR 0.152.
 */
package network.aika.debugger;

import java.awt.Color;
import java.util.function.Consumer;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public abstract class AbstractConsole
extends JTextPane {
    public static String NOT_SET_STR = "--";

    public AbstractConsole() {
        this.addStylesToDocument(this.getStyledDocument());
        this.setEditable(false);
        this.setFocusable(false);
    }

    public void render(Consumer<StyledDocument> content) {
        this.setOpaque(false);
        DefaultStyledDocument sDoc = new DefaultStyledDocument();
        this.addStylesToDocument(sDoc);
        content.accept(sDoc);
        SwingUtilities.invokeLater(() -> this.setStyledDocument(sDoc));
    }

    public void addStylesToDocument(StyledDocument doc) {
        Color green = new Color(0, 130, 0);
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        StyleConstants.setFontFamily(def, "SansSerif");
        Style regular = doc.addStyle("regular", def);
        StyleConstants.setFontSize(regular, 11);
        Style s = doc.addStyle("regularGreen", regular);
        StyleConstants.setForeground(s, green);
        s = doc.addStyle("regularGray", regular);
        StyleConstants.setForeground(s, Color.lightGray);
        s = doc.addStyle("italic", regular);
        StyleConstants.setItalic(s, true);
        Style bold = doc.addStyle("bold", regular);
        StyleConstants.setBold(bold, true);
        s = doc.addStyle("boldGreen", bold);
        StyleConstants.setForeground(s, green);
        s = doc.addStyle("boldGray", bold);
        StyleConstants.setForeground(s, Color.lightGray);
        s = doc.addStyle("small", regular);
        s = doc.addStyle("headline", regular);
        StyleConstants.setFontSize(s, 14);
    }

    public void clear() {
        StyledDocument sDoc = this.getStyledDocument();
        try {
            sDoc.remove(0, sDoc.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void appendEntry(StyledDocument sDoc, String fieldName, String fieldValue) {
        AbstractConsole.appendEntry(sDoc, fieldName, fieldValue, "bold", "regular");
    }

    public static void appendEntry(StyledDocument sDoc, String fieldName, String fieldValue, String titleStyle, String style) {
        AbstractConsole.appendText(sDoc, fieldName, titleStyle);
        AbstractConsole.appendText(sDoc, fieldValue + "\n", style);
    }

    protected static void appendText(StyledDocument sDoc, String txt, String style) {
        try {
            sDoc.insertString(sDoc.getLength(), txt, sDoc.getStyle(style));
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void addHeadline(StyledDocument sDoc, String headline) {
        AbstractConsole.appendText(sDoc, headline + "\n\n", "headline");
    }
}

