/*
 * Decompiled with CFR 0.152.
 */
package network.aika.debugger;

import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import network.aika.debugger.AbstractParticle;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;

public abstract class AbstractGraphManager<N, L, P extends AbstractParticle> {
    private Graph graph;
    private Map<String, N> nodeIdToAikaNode = new TreeMap<String, N>();
    private Map<Long, P> keyIdToParticle = new TreeMap<Long, P>();

    public AbstractGraphManager(Graph graph) {
        this.graph = graph;
    }

    public N getAikaNode(Node n) {
        return this.nodeIdToAikaNode.get(n.getId());
    }

    public N getAikaNode(String nodeId) {
        return this.nodeIdToAikaNode.get(nodeId);
    }

    public N getInputKey(Edge e) {
        return this.nodeIdToAikaNode.get(e.getId().substring(0, e.getId().indexOf("-")));
    }

    public N getOutputKey(Edge e) {
        return this.nodeIdToAikaNode.get(e.getId().substring(e.getId().indexOf("-") + 1));
    }

    protected abstract Long getAikaNodeId(N var1);

    public P getParticle(Node n) {
        return this.getParticle(Long.valueOf(n.getId()));
    }

    public P getParticle(N key) {
        return this.getParticle(this.getAikaNodeId(key));
    }

    public P getParticle(long keyId) {
        return (P)((Object)((AbstractParticle)((Object)this.keyIdToParticle.get(keyId))));
    }

    public void setParticle(N key, P particle) {
        this.keyIdToParticle.put(this.getAikaNodeId(key), particle);
    }

    public String getNodeId(N key) {
        return "" + this.getAikaNodeId(key);
    }

    public String getEdgeId(N iKey, N oKey) {
        return this.getAikaNodeId(iKey) + "-" + this.getAikaNodeId(oKey);
    }

    public Node lookupNode(N key, Consumer<Node> onCreate) {
        String id = this.getNodeId(key);
        Node node = this.graph.getNode(id);
        if (node == null) {
            this.nodeIdToAikaNode.put(id, key);
            node = this.graph.addNode(id);
            onCreate.accept(node);
        }
        return node;
    }

    public Node getNode(N key) {
        String id = this.getNodeId(key);
        return this.graph.getNode(id);
    }

    public Edge lookupEdge(N iKey, N oKey) {
        String edgeId = this.getEdgeId(iKey, oKey);
        Edge edge = this.graph.getEdge(edgeId);
        if (edge == null) {
            edge = this.graph.addEdge(edgeId, this.getNodeId(iKey), this.getNodeId(oKey), true);
        }
        return edge;
    }

    public Edge getEdge(N iKey, N oKey) {
        String edgeId = this.getEdgeId(iKey, oKey);
        return this.graph.getEdge(edgeId);
    }

    public Node getNode(String nodeId) {
        return this.graph.getNode(nodeId);
    }

    public abstract Edge lookupEdge(L var1);

    public abstract Edge getEdge(L var1);

    public abstract L getLink(Edge var1);
}

